# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for political ratings
data_party1 = np.random.normal(0.65, 0.10, 200)  # Party 1
data_party2 = np.random.normal(0.55, 0.12, 200)  # Party 2
data_party3 = np.random.normal(0.75, 0.08, 200)  # Party 3
xticklabels = ["Party 1", "Party 2", "Party 3"]
xlabel = "Political Parties"
ylabel = "Approval Rating"
title = "Approval Ratings of Political Parties"
ylim = [0.3, 1.0]
xticks = [1, 2, 3]
legend_labels = ["Party 1", "Party 2", "Party 3"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with specified dimensions
fig, ax = plt.subplots(figsize=(7, 5))  # Adjusted to match usual dimensions

# Create violin plots
violin_parts1 = ax.violinplot(data_party1, positions=[1], showmeans=True)
violin_parts2 = ax.violinplot(data_party2, positions=[2], showmeans=True)
violin_parts3 = ax.violinplot(data_party3, positions=[3], showmeans=True)

# Customize colors with vibrant colors
violin_parts1["bodies"][0].set_facecolor("#1f77b4")  # Blue
violin_parts2["bodies"][0].set_facecolor("#ff7f0e")  # Orange
violin_parts3["bodies"][0].set_facecolor("#2ca02c")  # Green

# Change mean line colors to black for each violin plot
for partname in ("cmeans", "cmaxes", "cmins", "cbars"):
    vp = violin_parts1[partname]
    vp.set_edgecolor("#000000")
    vp.set_linewidth(1)
    vp.set_linestyle("--")

    vp = violin_parts2[partname]
    vp.set_edgecolor("#000000")
    vp.set_linewidth(1)
    vp.set_linestyle("--")

    vp = violin_parts3[partname]
    vp.set_edgecolor("#000000")
    vp.set_linewidth(1)
    vp.set_linestyle("--")

# Set x-axis and y-axis labels
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Set y-axis limits
ax.set_ylim(ylim)

# Add a legend
labels = [
    r"$\mu={:.2f}, \sigma={:.2f}$".format(np.mean(data), np.std(data))
    for data in [data_party1, data_party2, data_party3]
]
ax.legend(
    handles=[
        plt.Line2D([], [], color=color, linestyle="--")
        for color in ["#1f77b4", "#ff7f0e", "#2ca02c"]
    ],
    labels=legend_labels,
    loc="upper left",
)

# ===================
# Part 4: Saving Output
# ===================
# tight layout
plt.tight_layout()

# Display the plot
plt.savefig("violin_31.pdf", bbox_inches="tight")
