
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data representing philosophical metrics
data_absurdity = np.random.normal(0.55, 0.1, 200)
data_morality = np.random.normal(0.65, 0.15, 200)
data_rationality = np.random.normal(0.75, 0.05, 200)

xticklabels = ["Absurdity", "Morality", "Rationality"]
ylabel = "Philosophical Metric Score"
xlabel = "Philosophical Metrics"
ylim = [0.2, 1.0]
xticks = [1, 2, 3]
title = "Distribution of Philosophical Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(6, 6))

# Create violin plots with new data
violin_parts1 = ax.violinplot(data_absurdity, positions=[1], showmeans=True)
violin_parts2 = ax.violinplot(data_morality, positions=[2], showmeans=True)
violin_parts3 = ax.violinplot(data_rationality, positions=[3], showmeans=True)

# Customize colors
violin_parts1["bodies"][0].set_facecolor("#556B2F")  # Dark Olive Green
violin_parts2["bodies"][0].set_facecolor("#8B0000")  # Dark Red (maroon)
violin_parts3["bodies"][0].set_facecolor("#008080")  # Teal

# Change mean line colors to a contrasting color
mean_line_color = "#FFD700"  # Gold
for partname in ("cmeans", "cmaxes", "cmins", "cbars"):
    for vp in (violin_parts1, violin_parts2, violin_parts3):
        vp[partname].set_edgecolor(mean_line_color)
        vp[partname].set_linewidth(1.2)

# Set x-axis and y-axis labels and title
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)

# Set y-axis limits
ax.set_ylim(ylim)

# ===================
# Part 4: Saving Output
# ===================
# Use a tight layout
plt.tight_layout()

# Display the plot
plt.savefig("violin_32.pdf", bbox_inches="tight")
