
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.lines import Line2D

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)  # Ensuring reproducibility
# Sample new data for a business domain
quarters = np.arange(1, 6)
strategy_a_data = np.random.rand(10, 100) * 150 + 100  # Simulate data for Strategy A
strategy_b_data = np.random.rand(10, 100) * 200 + 50   # Simulate data for Strategy B
titles = ["% Increase in Quarterly Sales vs. Strategy X", "% Increase in Quarterly Sales vs. Strategy Y"]
ylims = [[50, 300], [50, 300]]
xlabel = "Number of Quarters"
ytickslabels = [
    ["50%", "100%", "150%", "200%", "250%", "300%"],
    ["50%", "100%", "150%", "200%", "250%", "300%"],
]
xticklabel = [1, 2, 3, 4, 5]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots
fig, axs = plt.subplots(2, 1, figsize=(10, 10))
# Define the colors for the violin plots
color_strategy_a = "#1f77b4"  # Color for Strategy A
color_strategy_b = "#2ca02c"  # Color for Strategy B

# Function to set the color of the violin plot
def set_violin_color(violin, color):
    for body in violin["bodies"]:
        body.set_facecolor(color)
        body.set_edgecolor(color)
    # Set color for the median line
    violin["cmedians"].set_color(color)

# Top subplot: Strategy X
for i, quarter in enumerate(quarters):
    vl = axs[0].violinplot(
        strategy_a_data[i],
        positions=[quarter - 0.2],
        showmedians=True,
        widths=0.3,
        showextrema=False,
    )
    set_violin_color(vl, color_strategy_a)

    vl = axs[0].violinplot(
        strategy_b_data[i],
        positions=[quarter + 0.2],
        showmedians=True,
        widths=0.3,
        showextrema=False,
    )
    set_violin_color(vl, color_strategy_b)

    axs[0].text(
        quarter - 0.35,
        np.median(strategy_a_data[i]),
        f"{int(np.median(strategy_a_data[i]))}%",
        ha="right",
        va="bottom",
        color=color_strategy_a,
    )
    axs[0].text(
        quarter + 0.35,
        np.median(strategy_b_data[i]),
        f"{int(np.median(strategy_b_data[i]))}%",
        ha="left",
        va="bottom",
        color=color_strategy_b,
    )

axs[0].set_title(titles[0])
axs[0].set_xticks(quarters)
axs[0].set_ylim(ylims[0])
# remove x-axis label for the top subplot
axs[0].set_xticklabels([])
axs[0].set_yticklabels(ytickslabels[0])

# Bottom subplot: Strategy Y
for i, quarter in enumerate(quarters):
    vl = axs[1].violinplot(
        strategy_a_data[i],
        positions=[quarter - 0.2],
        showmedians=True,
        widths=0.3,
        showextrema=False,
    )
    set_violin_color(vl, color_strategy_a)

    vl = axs[1].violinplot(
        strategy_b_data[i],
        positions=[quarter + 0.2],
        showmedians=True,
        widths=0.3,
        showextrema=False,
    )
    set_violin_color(vl, color_strategy_b)

    axs[1].text(
        quarter - 0.35,
        np.median(strategy_a_data[i]),
        f"{int(np.median(strategy_a_data[i]))}%",
        ha="right",
        va="bottom",
        color=color_strategy_a,
    )
    axs[1].text(
        quarter + 0.35,
        np.median(strategy_b_data[i]),
        f"{int(np.median(strategy_b_data[i]))}%",
        ha="left",
        va="bottom",
        color=color_strategy_b,
    )

axs[1].set_title(titles[1])
axs[1].set_xticks(quarters)
axs[1].set_ylim(ylims[1])
axs[1].set_xlabel(xlabel)
axs[1].set_xticklabels(xticklabel)
axs[1].set_yticklabels(ytickslabels[1])

# use line to create a custom legend
legend_elements = [
    Line2D([0], [0], color=color_strategy_a, lw=2, label="Strategy A"),
    Line2D([0], [0], color=color_strategy_b, lw=2, label="Strategy B"),
]
axs[0].legend(handles=legend_elements, loc="upper left")
axs[1].legend(handles=legend_elements, loc="upper left")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("violin_39.pdf", bbox_inches="tight")
