# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate sample data for philosophy classes
philosophy_grades = {
    "Class A": {
        "Undergrads": np.random.normal(65, 10, 100),
        "Postgrads": np.random.normal(75, 8, 100),
    },
    "Class B": {
        "Undergrads": np.random.normal(70, 12, 100),
        "Postgrads": np.random.normal(80, 10, 100),
    },
    "Class C": {
        "Undergrads": np.random.normal(68, 9, 100),
        "Postgrads": np.random.normal(77, 11, 100),
    },
    "Class D": {
        "Undergrads": np.random.normal(67, 11, 100),
        "Postgrads": np.random.normal(79, 9, 100),
    },
}

title = "Distribution of Philosophy Grades:"
xticklabels = ["Undergrads", "Postgrads"]
xticks = [1, 2]

# Prepare data for violin plot
data_to_plot = []
for class_name, grades in philosophy_grades.items():
    data_to_plot.extend([grades for _, grades in grades.items()])

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure and an array of axes: 2x2 subplot grid
fig, axs = plt.subplots(nrows=2, ncols=2, figsize=(12, 8))

# Colors for the violins
colors = ["#add8e6", "#90ee90"]

# Flatten the axes array for easy iteration
axs = axs.flatten()

for i, (class_name, ax) in enumerate(zip(philosophy_grades, axs)):
    grades = philosophy_grades[class_name]
    parts = ax.violinplot(
        [grades["Undergrads"], grades["Postgrads"]], showmeans=False, showmedians=True
    )

    for pc, color in zip(parts["bodies"], colors):
        pc.set_facecolor(color)
        pc.set_edgecolor("black")
        pc.set_alpha(0.7)

    for partname in ("cbars", "cmins", "cmaxes", "cmedians"):
        vp = parts[partname]
        vp.set_edgecolor("black")
        vp.set_linewidth(1)

    ax.set_title(f"{title} {class_name}")
    ax.set_xticks(xticks)
    ax.set_xticklabels(xticklabels)
    ax.yaxis.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Improve spacing between subplots
plt.tight_layout()

plt.savefig("violin_46.pdf", bbox_inches="tight")
