
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)
# New data representing annual rainfall in different regions
data_RegionA = np.random.normal(800, 150, 200)  # mm of annual rainfall in Region A
data_RegionB = np.random.normal(600, 120, 200)  # mm of annual rainfall in Region B
data_RegionC = np.random.normal(400, 100, 200)  # mm of annual rainfall in Region C

xticklabels = ["Region A", "Region B", "Region C"]
ylabel = "Annual Rainfall (mm)"
title = "Annual Rainfall in Different Regions"
ylim = [100, 1200]
xticks = [1, 2, 3]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(8, 6))

# Create violin plots with enhanced styling
violin_parts1 = ax.violinplot(data_RegionA, positions=[1], showmeans=True)
violin_parts2 = ax.violinplot(data_RegionB, positions=[2], showmeans=True)
violin_parts3 = ax.violinplot(data_RegionC, positions=[3], showmeans=True)

# Customize colors
violin_parts1["bodies"][0].set_facecolor("#66c2a5")  # Green shade
violin_parts1["bodies"][0].set_alpha(0.7)

violin_parts2["bodies"][0].set_facecolor("#8da0cb")  # Blue shade
violin_parts2["bodies"][0].set_alpha(0.7)

violin_parts3["bodies"][0].set_facecolor("#fc8d62")  # Yellow-orange shade
violin_parts3["bodies"][0].set_alpha(0.7)

# Customize mean line colors and style
for partname in ("cmeans", "cmaxes", "cmins", "cbars"):
    # Region A
    vp = violin_parts1[partname]
    vp.set_edgecolor("#1f78b4")  # Dark blue
    vp.set_linestyle((0, (5, 2)))  # Dotted line
    vp.set_linewidth(1.5)

    # Region B
    vp = violin_parts2[partname]
    vp.set_edgecolor("#1f78b4")  # Dark blue
    vp.set_linestyle((0, (5, 2)))
    vp.set_linewidth(1.5)

    # Region C
    vp = violin_parts3[partname]
    vp.set_edgecolor("#1f78b4")  # Dark blue
    vp.set_linestyle((0, (5, 2)))
    vp.set_linewidth(1.5)

# Set x-axis and y-axis labels
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Add grid lines for better readability
ax.grid(True, linestyle="--", alpha=0.6)

# Set y-axis limits
ax.set_ylim(ylim)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("violin_69.pdf", bbox_inches="tight")
