# ===================
# Part 1: Importing Libraries
# ===================
import numpy as np

np.random.seed(0)

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Replace None with np.nan to create an array with NaN values
data = np.array(
    [
        [np.nan, np.nan, 1, np.nan],
        [4, 8, 16, 7],
        [np.nan, np.nan, 12, 28],
        [3, 4, 16, 22],
    ]
)
xticklabels = ["D'2", "D'1", "D'0", "="]
yticklabels = ["LOH0", "LOH1", "LOH2", "LOMLP"]
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a heatmap, setting NaN values' color to grey
cmap = plt.cm.BrBG_r
cmap.set_bad("gray", 1.0)

# Draw the heatmap
fig, ax = plt.subplots(figsize=(6, 6))
cax = ax.matshow(data, cmap=cmap)

# Add text
for (i, j), val in np.ndenumerate(data):
    if not np.isnan(val):  # Only add text for non-NaN values
        ax.text(j, i, f"{val}%", va="center", ha="center")

# Set axis labels.
ax.set_xticks(np.arange(data.shape[1]))
ax.set_yticks(np.arange(data.shape[0]))

# Set axis tick labels
ax.set_xticklabels(xticklabels)
ax.set_yticklabels(yticklabels)

# Turn off the gridlines generated by the ticks
ax.grid(False)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("heatmap_13.pdf", bbox_inches="tight")
