function [phase_transition_snr] = binary_search_snr(n, p, m, opts)

% ORACLE = 0;
% NON_ORACLE = 1; 

NOISE_VAR = 1.0;

SIMUL_NUM = 100;

COR_THRES = 0.95; 

GAP_THRES = 10^(-4); 

%%  specify the h value 

h = floor(n/10);  

lsnr = 0.0; 
rsnr = 10.0;  

phase_transition_snr = 0; 

while rsnr > lsnr + GAP_THRES

    msnr = lsnr + (rsnr - lsnr)/2.0; 

    corr_rate = cmpt_recover_rate(msnr, ... % SNR value
                                  NOISE_VAR, ... % Sensing noise variance
                                  n, p, m, h, ...
                                  SIMUL_NUM,... % simulation number for the correct rate 
                                  opts);      % the estimator type

    if corr_rate > COR_THRES

        phase_transition_snr = msnr;

        rsnr = msnr - GAP_THRES ;

    else

        lsnr = msnr + GAP_THRES; 

    end
       
end


end








