function [corr_rate] = cmpt_recover_rate( snr, noise_var, n, p, m, h, simul_num, opts)

ORACLE = 0;
NON_ORACLE = 1;

corr_rate = 0; 

for sidx = 1:1:simul_num

    % Create the signal

    [Y, Pi_orig, X, B] = create_signal(snr, noise_var, n, p, m, h); 

    % Reconstruct the permutation 

    if opts == ORACLE

        Pi_hat = permuteproj(Y * B.' * X.'); 

    else

        Pi_hat = permuteproj(Y * Y.' * X * X.'); 
    end

    % Check whether the reconstruct is correct or not.

    if norm(Pi_orig - Pi_hat, 'fro') < 1
        corr_rate = corr_rate + 1;
    end

end

corr_rate = corr_rate/simul_num; 


end





