### Example
* run files in `experiments`
  * `crime_pretraining_mdp.sh`: run pretraining for matched Gibbs constraint
  * `crime_pretraining_mmd.sh`: run pretraining for Gibbs with MMD constraint
  * `crime_gibbs_matching_mdp.sh`: run matched Gibbs
    * run `crime_gibbs_matching_mdp.sh` after running `crime_pretraining_mdp.sh`
  * `crime_gibbs_mmd.sh`: run Gibbs with MMD constraint
    * run `crime_gibbs_mmd.sh` after running `crime_pretraining_mmd.sh`
  * `crime_mfg_mmd.sh`: run mean-field Gaussian variational inference with MMD constraint

### Files
* `main.py`: main file
* `src`: source code
  * `runner_bayesian.py`: runner for Gibbs_mmd and Gibbs_matched
  * `runner_variational.py`: runner for mean-field Gaussian variational inference
  * `train.py`: training script
  * `eval.py`: evaluation script
  * `loss.py`: loss functions
  * `models.py`: models
  * `dataset.py`: torch dataset with sensitive attributes, balanced sampler
  * `utils.py`: utility functions
* `hamiltorch`: code for Hamiltonian Monte Carlo (modified from the original code: https://github.com/hamiltorch/hamiltorch)
* `data`: data preprocessing code
  * `preprocessor.py`: data preprocessor for all datasets
  * `registry.py`: registry for each data preprocessors
  * `datasets`: datasets
    * `adult.py`: adult dataset
    * `crime.py`: crime dataset
    * `dutch.py`: dutch dataset
    * `celeba_hq.py`: celeba_mask_hq dataset
    * `civil_roberta.py`: civilcomments dataset with Roberta embedding
  * `celeba_HQ`: celeba_HQ dataset
    * `embedding.py`: embedding code
* `experiments`: example scripts