class optimizer_config:
    def __init__(self):
        # optimizer config
        self.max_grad_norm = 1
        self.batch_size = 128
        self.train_batch_size = 128
        self.dev_batch_size = 128
        self.bucket_size_factor = 5
        self.DataParallel = False
        self.num_workers = 6
        self.weight_decay = 1e-2
        self.lr = 1e-3
        self.epochs = 100
        self.early_stop_patience = 5
        self.scheduler = "ReduceLROnPlateau"
        self.scheduler_patience = 2
        self.scheduler_reduce_factor = 0.5
        self.optimizer = "Ranger"
        self.save_by = "accuracy"
        self.metric_direction = +1
        self.different_betas = False
        self.chunk_size = -1
        self.display_metric = "accuracy"


class base_config(optimizer_config):
    def __init__(self):
        super().__init__()
        self.word_embd_freeze = True
        self.initial_transform = False
        self.batch_pair = False
        self.embd_dim = 300
        self.input_size = 300
        self.hidden_size = 300
        self.rao_k = 10
        self.classifier_hidden_size = 300
        self.rao = False
        self.stochastic = False
        self.test_time_stochastic = False
        self.global_state_only = True
        self.global_state_return = True
        self.gumbel_diff = False
        self.parse_trees = False


class NDR_config(base_config):
    def __init__(self):
        super().__init__()
        self.input_size = 512
        self.hidden_size = 512
        self.embd_dim = 512
        self.batch_pair = False
        self.batch_size = 512
        self.train_batch_size = 128
        self.optimizer = "AdamW"
        self.weight_decay = 0.09
        self.in_dropout = 0.1
        self.scheduler = None
        self.early_stop_patience = 100
        self.save_by = "accuracy"
        self.dropout = 0.1
        self.out_dropout = 0.1
        self.train_max_depth = 10
        self.test_max_depth = 24
        self.metric_direction = +1
        self.lr = 2e-4
        self.ff_dim = 1024
        self.heads = 16
        self.encoder_type = "ndr_geometric_stack"
        self.model_name = "(NDR)"


class GumbelTreeLSTM_config(base_config):
    def __init__(self):
        super().__init__()
        self.in_dropout = 0.3
        self.dropout = 0.3
        self.out_dropout = 0.3
        self.conv_decision = False
        self.encoder_type = "GumbelTreeLSTM"
        self.model_name = "(GumbelTreeLSTM)"


class RCell_config(base_config):
    def __init__(self):
        super().__init__()
        self.in_dropout = 0.4
        self.dropout = 0.2
        self.out_dropout = 0.4
        self.bidirectional = False
        self.encoder_type = "BiCell"
        self.model_name = "(RCell)"


class BiCell_config(RCell_config):
    def __init__(self):
        super().__init__()
        self.bidirectional = True
        self.encoder_type = "BiCell"
        self.model_name = "(BiCell)"


class GoldTreeCell_config(BiCell_config):
    def __init__(self):
        super().__init__()
        self.parse_trees = True
        self.encoder_type = "GoldTreeCell"
        self.model_name = "(GoldTreeCell)"

class RandomTreeCell_config(BiCell_config):
    def __init__(self):
        super().__init__()
        self.train_batch_size = 64
        self.conv_decision = False
        self.encoder_type = "RandomTreeCell"
        self.model_name = "(RandomTreeCell)"

class CRvNN_config(BiCell_config):
    def __init__(self):
        super().__init__()
        self.train_batch_size = 16
        self.encoder_type = "CRvNN"
        self.model_name = "(CRvNN)"

class OrderedMemory_config(BiCell_config):
    def __init__(self):
        super().__init__()
        self.memory_dropout = 0.2
        self.memory_slots = 15
        self.encoder_type = "OrderedMemory"
        self.model_name = "(ordered_memory)"


class BalancedTreeCell_config(BiCell_config):
    def __init__(self):
        super().__init__()
        self.encoder_type = "BalancedTreeCell"
        self.model_name = "(BalancedTreeCell)"


class GumbelTreeCell_config(BiCell_config):
    def __init__(self):
        super().__init__()
        self.train_batch_size = 64
        self.conv_decision = False
        self.encoder_type = "GumbelTreeCell"
        self.model_name = "(GumbelTreeCell)"

class MCGumbelTreeCell_config(BiCell_config):
    def __init__(self):
        super().__init__()
        self.conv_decision = False
        self.train_batch_size = 16
        self.sample_size = 5
        self.encoder_type = "MCGumbelTreeCell"
        self.model_name = "(MCGumbelTreeCell)"


class BeamTreeLSTM_config(GumbelTreeLSTM_config):
    def __init__(self):
        super().__init__()
        self.conv_decision = False
        self.train_batch_size = 16
        self.diffop1 = False
        self.diffop2 = False
        self.stochastic = True
        self.beam_size = 5
        self.encoder_type = "BeamGumbelTreeLSTM"
        self.model_name = "(BeamTreeLSTM)"


class DiffBeamTreeCell_config(GumbelTreeCell_config):
    def __init__(self):
        super().__init__()
        self.conv_decision = False
        self.diffop1 = False
        self.train_batch_size = 8
        self.diffop2 = False
        self.stochastic = True
        self.beam_size = 5
        self.encoder_type = "DiffBeamTreeCell"
        self.model_name = "(DiffBeamTreeCell)"

class GumbelDiffBeamTreeCell_config(GumbelTreeCell_config):
    def __init__(self):
        super().__init__()
        self.conv_decision = False
        self.train_batch_size = 8
        self.diffop1 = False
        self.diffop2 = False
        self.stochastic = True
        self.gumbel_diff = True
        self.beam_size = 5
        self.encoder_type = "DiffBeamTreeCell"
        self.model_name = "(GumbelDiffBeamTreeCell)"

class SmallerGumbelDiffBeamTreeCell_config(GumbelTreeCell_config):
    def __init__(self):
        super().__init__()
        self.conv_decision = False
        self.train_batch_size = 16
        self.diffop1 = False
        self.diffop2 = False
        self.stochastic = True
        self.gumbel_diff = True
        self.beam_size = 2
        self.encoder_type = "DiffBeamTreeCell"
        self.model_name = "(SmallerGumbelDiffBeamTreeCell)"

class SmallerDiffBeamTreeCell_config(GumbelTreeCell_config):
    def __init__(self):
        super().__init__()
        self.conv_decision = False
        self.train_batch_size = 16
        self.diffop1 = False
        self.diffop2 = False
        self.stochastic = True
        self.beam_size = 2
        self.encoder_type = "DiffBeamTreeCell"
        self.model_name = "(SmallerDiffBeamTreeCell)"


class StochasticBeamTreeCell_config(GumbelTreeCell_config):
    def __init__(self):
        super().__init__()
        self.conv_decision = False
        self.train_batch_size = 16
        self.diffop1 = False
        self.diffop2 = False
        self.stochastic = True
        self.test_time_stochastic = False
        self.beam_size = 5
        self.encoder_type = "BeamGumbelTreeCell"
        self.model_name = "(StochasticBeamTreeCell)"

class ConvBeamTreeCell_config(StochasticBeamTreeCell_config):
    def __init__(self):
        super().__init__()
        self.train_batch_size = 16
        self.conv_decision = True
        self.diffop1 = False
        self.diffop2 = False
        self.stochastic = True
        self.test_time_stochastic = False
        self.conv_decision = True
        self.beam_size = 5
        self.encoder_type = "BeamGumbelTreeCell"
        self.model_name = "(ConvBeamTreeCell)"

class BeamTreeCellGM_config(GumbelTreeCell_config):
    def __init__(self):
        super().__init__()
        self.train_batch_size = 16
        self.conv_decision = False
        self.diffop1 = False
        self.diffop2 = False
        self.stochastic = True
        self.test_time_stochastic = False
        self.gumbel_marginalization = True
        self.beam_size = 5
        self.encoder_type = "BeamGumbelTreeCell"
        self.model_name = "(BeamTreeCellGM)"


class Beam1GumbelTreeCell_config(GumbelTreeCell_config):
    def __init__(self):
        super().__init__()
        self.conv_decision = False
        self.train_batch_size = 16
        self.diffop1 = True
        self.diffop2 = False
        self.stochastic = True
        self.test_time_stochastic = False
        self.beam_size = 5
        self.encoder_type = "BeamGumbelTreeCell"
        self.model_name = "(Beam1GumbelTreeCell)"


class SmallBeam1GumbelRaoTreeCell_config(GumbelTreeCell_config):
    def __init__(self):
        super().__init__()
        self.train_batch_size = 16
        self.conv_decision = False
        self.diffop1 = True
        self.diffop2 = False
        self.stochastic = True
        self.test_time_stochastic = False
        self.rao = True
        self.beam_size = 3
        self.encoder_type = "BeamGumbelTreeCell"
        self.model_name = "(SmallBeam1GumbelRaoTreeCell)"


class SmallerBeamTreeCell_config(GumbelTreeCell_config):
    def __init__(self):
        super().__init__()
        self.train_batch_size = 32
        self.conv_decision = False
        self.diffop1 = False
        self.diffop2 = False
        self.stochastic = True
        self.test_time_stochastic = False
        self.beam_size = 2
        self.encoder_type = "BeamGumbelTreeCell"
        self.model_name = "(SmallerBeamTreeCell)"
