class Transformer_hyperconfig:
    def __init__(self):
        super().__init__()
        self.encode_layers = [3, 4, 6]
        self.heads = [4, 6, 8]
        self.dropout = [0.1, 0.2, 0.3]
        self.max_trials = 50
        self.allow_repeat = False
        self.hyperalgo = "hyperopt.rand.suggest"
        self.epochs = 3
        self.limit = -1

    def process_config(self, config):
        config["in_dropout"] = config["dropout"]
        config["out_dropout"] = config["dropout"]
        config["head_dim"] = config["hidden_size"]//config["heads"]
        return config
