class Transformer_hyperconfig:
    def __init__(self):
        super().__init__()
        self.encode_layers = [3, 4, 6]
        self.heads = [4, 6, 8]
        self.lr = [1e-3, 1e-4]
        self.ff_factor = [1, 2, 4]
        self.dropout = [0.1, 0.2, 0.3, 0.4]
        self.max_trials = 100
        self.allow_repeat = False
        self.hyperalgo = "hyperopt.rand.suggest"
        self.epochs = 5
        self.limit = -1

    def process_config(self, config):
        config["ff_dim"] = config["ff_factor"] * config["hidden_size"]
        config["in_dropout"] = config["dropout"]
        config["attn_dropout"] = config["dropout"]
        config["out_dropout"] = config["dropout"]
        config["head_dim"] = config["hidden_size"]//config["heads"]
        return config
