
class optimizer_config:
    def __init__(self):
        # optimizer config
        self.max_grad_norm = 1
        self.batch_size = 32
        self.train_batch_size = 32
        self.dev_batch_size = 32
        self.bucket_size_factor = 1
        self.DataParallel = False
        self.num_workers = 6
        self.weight_decay = 0
        self.lr = 0.01
        self.epochs = 100
        self.early_stop_patience = 10
        self.scheduler = "ReduceLROnPlateau"
        self.scheduler_patience = 2
        self.scheduler_reduce_factor = 0.5
        self.optimizer = "Adam"
        self.save_by = "F1"
        self.metric_direction = 1
        self.different_betas = False
        self.chunk_size = -1


class base_config(optimizer_config):
    def __init__(self):
        super().__init__()
        self.word_embd_freeze = True
        self.position_max_len = 5000
        self.embd_dim = 300
        self.hidden_size = 150
        self.ff_dim = 4 * self.hidden_size
        self.attention_type = "Multiheaded_Attention"
        self.global_state_return = False
        self.global_state_only = False
        self.attn_dropout = 0.0
        self.display_metric = "F1"
        self.initial_transform = False
        self.post_cat_transform = False
        self.use_feats = False
        self.use_char_feats = False
        self.char_embed_dim = 30
        self.char_out_dim = 30
        self.char_window_size = 3


class LSTM_config(base_config):
    def __init__(self):
        super().__init__()
        self.use_feats = True
        self.use_char_feats = True
        self.lr = 0.005
        self.in_dropout = 0.5
        self.out_dropout = 0.1
        self.input_size = self.embd_dim + 35
        self.hidden_size = 512
        self.encoder_type = "LSTM"
        self.model_name = "(LSTM)"

class Transformer_config(base_config):
    def __init__(self):
        super().__init__()
        self.post_cat_transform = True
        self.use_feats = True
        self.use_char_feats = True
        self.lr = 0.005
        self.in_dropout = 0.5
        self.out_dropout = 0.1
        self.input_size = self.embd_dim + 35
        self.hidden_size = 512
        self.encode_layers = 4
        self.dropout = 0.1
        self.heads = 8
        self.head_dim = self.hidden_size // self.heads
        self.attention_type = "Multiheaded_Attention"
        self.encoder_type = "TransformerEncoder"
        self.model_name = "(Transformer)"

class TreeTransformer_config(Transformer_config):
    def __init__(self):
        super().__init__()
        self.encoder_type = "TreeTransformerEncoder"
        self.model_name = "(TreeTransformer)"

class UniversalTransformer_config(Transformer_config):
    def __init__(self):
        super().__init__()
        self.in_dropout = 0.1
        self.dropout = 0.1
        self.out_dropout = 0.2
        self.heads = 8
        self.head_dim = 64
        self.penalty_gamma = 0.001
        self.upperbound_style = "fixed"
        self.upperbound = 10
        self.threshold = 0.99
        self.attention_type = "Multiheaded_Attention"
        self.encoder_type = "UniversalTransformerEncoder"
        self.model_name = "(Universal Transformer)"

class Structformer_config(Transformer_config):
    def __init__(self):
        super().__init__()
        self.encoder_type = "StructFormer"
        self.model_name = "(Structformer)"

class AnotherTreeTransformer_config(base_config):
    def __init__(self):
        super().__init__()
        self.max_depth = 10
        self.scorer_window_size = 5
        self.stop_threshold = 0.2

        self.in_dropout = 0.1
        self.dropout = 0.1
        self.out_dropout = 0.2
        self.heads = 8
        self.head_dim = 64

        self.encoder_type = "AnotherTreeTransformer"
        self.model_name = "(ATT)"



class OrderedMemory_config(base_config):
    def __init__(self):
        super().__init__()
        self.batch_pair = True
        self.dropout = 0.2
        self.output_last = False
        self.left_padded = False
        self.memory_dropout = 0.2
        self.in_dropout = 0.1
        self.out_dropout = 0.3
        self.memory_slots = 12
        self.double_slots_during_val = True
        self.hidden_size = 200
        self.bidirection = False
        self.different_betas = True
        self.encoder_type = "OrderedMemory"
        self.model_name = "(OrderedMemory)"
        self.optimizer = "Adam"
        self.weight_decay = 1.2e-6
        self.max_grad_norm = 1

class SeqCRvNN_config(base_config):
    def __init__(self):
        super().__init__()
        self.post_cat_transform = True
        self.use_feats = True
        self.use_char_feats = True

        self.lr = 0.005
        self.input_size = self.embd_dim + 35
        self.max_depth = 20
        self.scorer_window_size = 5
        self.stop_threshold = 0.2
        self.in_dropout = 0.5
        self.dropout = 0.1
        self.out_dropout = 0.1
        self.hidden_size = 512
        self.aux_entropy_gamma = 0.01

        self.encoder_type = "SeqCRvNN"
        self.model_name = "(SeqCRvNN)"




