# Video Plan Generation Instructions

## Setup
```
pip install -r requirements.txt
```
Then edit the `.env` file and put your openai related information. The below keys must be in the env file:
```
API_KEY=...
API_BASE=...
API_TYPE=...
API_VERSION=...
```

## Running

Create a json file like:
```json
{
    "video000001": "A dog moving from left to right",
    "video000002": "A car moving from right to left",
    "video000003": "A book dropping from air to floor"
}
```

For single-scene, you can generate plans with the following command:
```bash
python src/single_scene.py --input_json xxxx.json --output_dir xxx
```

For multi-scene, you can generate plans with the following command:
```bash
python src/multi_scene.py --input_json xxxx.json --output_dir xxx
```


This will output JSON files that contains the planning information.