# SPARTA: Advancing Sparse Attention in Spiking Neural Networks via Spike-Timing-Based Prioritization

This Folder contains the implementation of SPARTA (SPARse aTtention), a novel architecture for efficient spiking neural networks with sparse attention mechanisms.

## Project Structure

# SPARTA Project Structure

model/                     # Model architecture
    layers.py              # SPARTA core modules
    model.py               # SPARTA wrapper class
utils/                     # Utility functions  
    augment.py             # Neuromorphic Data Augmentation (NDA)
    datasets.py            # Dataset handlers
    metrics.py             # Evaluation metrics
config/                    # Configuration files
train.py                   # Training script
test.py                    # Testing script
eval.py                    # Performance evaluation script

# Key Components Overview

# Model Architecture (model/)
- layers.py: SPARTA core modules
  * STEN (Spatio-Temporal Encoding Network)
  * MSP (Multi-Scale Processing) 
  * PatchGrouper
  * STSG (Spike Token Selection & Gating)
  * SC (Sparse Classifier)
  * FeedbackController
  * HILIFNode (Heterogeneous Initialized LIF neuron)

- model.py: SPARTA pipeline wrapper
  * Complete 6-stage pipeline
  * STEN → MSP → PatchGrouper → STSG → SC → FeedbackController

# Utilities (utils/)
- augment.py: Neuromorphic Data Augmentation
  * Temporal-aware transforms
  * Dataset-adaptive parameters
  * Monitoring system

- datasets.py: Dataset management
  * DVS Gesture Dataset
  * CIFAR10-DVS Dataset  
  * CIFAR-10 Dataset
  * CIFAR-100 Dataset
  * SNN-optimized encoding

- metrics.py: Comprehensive evaluation
  * Classification metrics
  * Spike operations metrics
  * Temporal variance metrics
  * Sparse attention metrics
  * Complexity metrics

# Training Scripts
- train.py: Training functions
- test.py: Testing functions  
- eval.py: Performance analysis

# Usage Commands
python train.py --cfg config/dataset_config.yaml --output_dir ./results
python test.py --cfg config/dataset_config.yaml --resume ./results/best_model.pth
python eval.py --cfg config/dataset_config.yaml --resume ./results/best_model.pth --output_dir ./eval_results



