import numpy as np
import pandas as pd
import csv

# def get_whether_valid_participant(client_i):
#     # client_i: 第i个client, 从0开始计数
#     if client_i < 20:
#         valid_mu = 0.850 + client_i * 0.005
#     elif client_i < 220:
#         valid_mu = 0.1 + (client_i-20) * (0.8-0.1)/200
#     elif client_i < 370:
#         valid_mu = 0.45 + (client_i-220) * (0.8-0.45)/150
#     else:
#         valid_mu = 0.45 - (client_i-370) * (0.45-0.1)/150
#     #return valid_mu
#     return np.random.binomial(1, valid_mu)

# def get_utility(client_i):
#     # client_i: 第i个client, 从0开始计数
#     if client_i < 20:
#         utility_mu = 0.995 - client_i * 0.005
#         utility_var = 0.01
#     elif client_i < 220:
#         utility_mu = 0.1 + (client_i-20) * (0.8-0.1)/200
#         utility_var = 0.015 - (client_i-20) * (0.015-0.005)/200   
#     elif client_i < 370:
#         utility_mu = 0.8 - (client_i-220) * (0.8-0.1)/150
#         utility_var = 0.005 + (client_i-220) * (0.01-0.005)/150
#     else:
#         utility_mu = 0.4 + (client_i-370) * (0.8-0.4)/150
#         utility_var = 0.001 + (client_i-370) * (0.015-0.001)/150
#     #return utility_mu, utility_var
#     return np.random.normal(utility_mu, utility_var, 1)

# def write_to_csv(filename):
#     # 调用该函数的时候，注意修改get_whether_valid_participant和get_utility函数的返回值
#     with open(filename, mode='w', newline='') as file:
#         writer = csv.writer(file)
#         # 写入表头
#         writer.writerow(['client_i', 'valid_mu', 'utility_mu', 'utility_var'])
        
#         # 生成数据并写入
#         for client_i in range(520):
#             valid_mu = get_whether_valid_participant(client_i)
#             utility_mu, utility_var = get_utility(client_i)
#             writer.writerow([client_i, valid_mu, utility_mu, utility_var])

        
# 读取 CSV 文件
csv_file_path = '/home/xschen/workspace/fd_learning/simulator/simDataset/clients_vu_for_sim.csv'
df = pd.read_csv(csv_file_path)

def get_whether_valid_participant(client_i):
    valid_mu = df.loc[df['client_i'] == client_i, 'valid_mu'].values
    if valid_mu.size == 0:
        raise ValueError(f"client_i {client_i} not found in CSV")
    valid_mu = valid_mu[0]
    return np.random.binomial(1, valid_mu)

def get_utility(client_i):
    utility_data = df.loc[df['client_i'] == client_i, ['utility_mu', 'utility_var']].values
    if utility_data.shape[0] == 0:
        raise ValueError(f"client_i {client_i} not found in CSV")
    utility_mu, utility_var = utility_data[0]
    return np.random.normal(utility_mu, utility_var, 1)  


if __name__ == '__main__':
    # csv_path = '/home/xschen/workspace/fd_learning/simulator/simDataset/clients_data.csv'
    # write_to_csv(csv_path)
    # csv_path = '/home/xschen/workspace/fd_learning/simulator/simDataset/temp.csv'
    # participate_data = [ 200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,   200,200,   200,   200,   200,   200,   200,   1,   1,   1,   1,   9,   1,   1,   1,1,   1,   1,   1,   1,   1,   1,   3,   1,  12,   5,   1,   1,   1,1,  12,   4,   9,   1,   1,   3,  13,   3,   1,   1,   1,   1,   1,1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   9,   1,5,   2,  12,   2,   9,   1,  13,   1,   3,   1,   5,  10,  10,   1,5,   5,   9,   5,   1,   1,   8,   5,   1,   1,   1,   2,   1,   1,1,  13,   5,   1,   1,   2,   8,   5,   1,   6,   8,   1,   1,  10,1,   3,   1,   1,  13,   1,   9,  10,  67,  29,  48,  29,  40,  15,39,  39,  26,  29,  14,  38,  14,  32,  38,  38,  26,  47,  60,  39,40,  26,  37,  55,  48,  29,  23,  43,  37,  62,  48,  21,  30,  54,34,  35,  39,  38,  36,  40,  28,  37,  28,  29,  29,  28,  38,  38,36,  55,  98, 117, 107, 152, 110, 108, 119,  98, 117, 133, 106,  98,138, 106, 141, 175, 148, 108, 108, 165, 103, 141, 155, 110, 133, 154,110, 117, 164, 106, 156, 103, 107,  98, 141, 100, 134, 107, 112, 104,115, 128, 111, 100, 145, 168, 105, 107, 100, 123,  29,  36, 105,  52,72,  28,  55,  26,  29,  29,  53,  40,  65,  28,  37,  56,  39,  83,64,  37,  95,  73,  39,  87,  14,  36,  53,  53,  38,  55,  33,  82,73,  14,  36,  83,  45,  52,  55,  29,  48,  29,  30,  47,  48,  48,37,  56,  29,  55,  39,  77,  53,  48,  37,  90,  19,  33,  33,  29,45,  64,  72,  67,  48,  40,  40,  52,  56,  92,  32,  65,  55,  82,26,  75,  65,  94,  48,  15,  74,  33,  56,  88,  13,  65,  36,  32,28,  94,  26,  53,  83,  15,  40,  75,  82,  75,  89,  48,  43,  40,60,  14,  50,  82,  28,  87,  30,  70,  65,  26,  67,  87,  47,  48,14,  73,  37,  55,  29,  48,  48,  65,  62,  62,  28,  12,  28,  48,9,  56,  36,  29,  29,  83,  15, 108,  55,  53,  70,  29,  65,  29,13,  13,  65,  52,  13,  29,  18,  18,   8,  14,   1,   1,  15,   1,15,  15,   1,   3,  14,   1,  17,   1,   8,   1,   9,   6,   5,   6,18,   1,  14,  15,   6,   6,   1,  15,  17,  23,   1,  12,   1,   1,1,  10,   1,   1,  26,   1,   1,  15,  18,   1,  20,  18,   1,  12,5,  15,   1,  11,  12,   4,   8,   1,  15,   1,   1,   1,  10,   1,1,  15,   1,   1,  15,   1,  15,  12,   3,   1,   1,   1,   1,   6,13,   1,   8,   3,   6,   1,  15,  12,   1,   4,  15,   1,   1,  14,6,   8,   6,   3,  14,   5,   1,   9,   1,   1,   1,   1,   1,  15,9,   1,   1,   1,   1,   1,   1,   1,  12,   4,   1,  14,   9,  14,1,   8,   1,  10,   9,  14,   1,   1,   1,   1,  14,  14,   1,  13,1,  14,   9,   1,   1,  11,   1,   6,   4,  12,   9,   1,   1,   1,1,  18]
    # with open(csv_path, mode='w', newline='') as file:
    #     writer = csv.writer(file)
    #     writer.writerow(['client_i', 'participate_round'])
    #     # 写入数据
    #     for i, value in enumerate(participate_data):
    #         writer.writerow([i, value])  # 这里假设 valid_mu 和 utility_mu 为空字符串，稍后可以根据实际情况填入

    #filename = '/home/xschen/workspace/fd_learning/simulator/simDataset/clients_vu_for_sim.csv'
    #write_to_csv(filename)  # 调用该函数的时候，注意修改get_whether_valid_participant和get_utility函数的返回值
    #pass

#     participate_data = [  1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
#    1,   1,   1,   1,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,
#   57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,
#   57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,
#   57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  57,  26,  26,  26,
#   26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
#   26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
#   26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,  26,
#   26,  26,  26,  26,  26,  15,  15,  15,  15,  15,  15,  15,  15,  15,
#   15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,
#   15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,
#   15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,   2,
#    2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
#    2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
#    2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
#    2,   2,   2,   2,   2,   2,   2,  45,  45,  45,  45,  45,  45,  45,
#   45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,
#   45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,
#   45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,  45,
#   45,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
#    7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
#    7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
#    7,   7,   7,   7,   7,   7,   7,   7,   7,  52,  52,  52,  52,  52,
#   52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,
#   52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,
#   52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,  52,
#   52,  52,  52,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,
#   15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,
#   15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,
#   15,  15,  15,  15,  15,  15,  15,  15,  15,  15,  15,   2,   2,   2,
#    2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
#    2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
#    2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,   2,
#    2,   2,   2,   2,   2,   9,   9,   9,   9,   9,   9,   9,   9,   9,
#    9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
#    9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,
#    9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   9,   3,
#    3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
#    3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
#    3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
#    3,   3,   3,   3,   3,   3,   3,   4,   4,   4,   4,   4,   4,   4,
#    4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
#    4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
#    4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,   4,
#    4,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
#    5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
#    5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,   5,
#    5,   5,   5,   5,   5,   5,   5,   5,   5,  63,  63,  63,  63,  63,
#   63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,
#   63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,
#   63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,  63,
#   63,  63,  63,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
#    7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
#    7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7,
#    7,   7,   7,   7,   7,   7,   7,   7,   7,   7,   7, 286, 286, 286,
#  286, 286, 286, 286, 286, 286, 286, 286, 286, 286, 286, 286, 286, 286,
#  286, 286, 286, 286, 286, 286, 286, 286, 286, 286, 286, 286, 286, 286,
#  286, 286, 286, 286, 286, 286, 286, 286, 286, 286, 286, 286, 286, 286,
#  286, 286, 286, 286, 286,  24,  24,  24,  24,  24,  24,  24,  24,  24,
#   24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,
#   24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,
#   24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,  37,
#   37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,
#   37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,
#   37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,  37,
#   37,  37,  37,  37,  37,  37,  37, 278, 278, 278, 278, 278, 278, 278,
#  278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
#  278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
#  278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278, 278,
#  278, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114,
#  114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114,
#  114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114, 114,
#  114, 114, 114, 114, 114, 114, 114, 114, 114, 275, 275, 275, 275, 275,
#  275, 275, 275, 275, 275, 275, 275, 275, 275, 275, 275, 275, 275, 275,
#  275, 275, 275, 275, 275, 275, 275, 275, 275, 275, 275, 275, 275, 275,
#  275, 275, 275, 275, 275, 275, 275, 275, 275, 275, 275, 275, 275, 275,
#  275, 275, 275,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
#    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
#    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
#    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
#    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
#    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
#    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
#    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
#    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
#    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
#    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
#    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
#    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
#    0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
#    0,   0,   0,   0,   0,   0,   0,   0,]
#     csv_path = '/home/xschen/workspace/fd_learning/simulator/simDataset/temp.csv'
#     with open(csv_path, mode='w', newline='') as file:
#         writer = csv.writer(file)
#         writer.writerow(['client_i', 'participate_round'])
#         # 写入数据
#         for i, value in enumerate(participate_data):
#             writer.writerow([i, value])  
    pass
