def get_verbosity_prompt():
    system_prompt = "You are a helpful assistant in evaluating the correctness of the answers for a given math problem. Your goal is to select the correct output for the given problem."
    user_template = """
    Select the Output (a) or Output (b) that provides the correct answer for the given math problem.

    Here are some rules of the evaluation:
    (1) Your primary objective is to focus on mathematical correctness, determining which output contains the correct mathematical answer.
    (2) You should avoid any potential bias and your judgment should be as objective as possible. For example, the length of the outputs should NOT affect your judgment, as longer responses are not necessarily better than shorter ones.

    Do NOT provide any explanation for your choice.
    Do NOT say both / neither are good.
    You should answer using ONLY "Output (a)" or "Output (b)". Do NOT output any other words.

    # Instruction:
    {input}

    # Output (a):
    {output_1}

    # Output (b):
    {output_2}

    # Which is correct, Output (a) or Output (b)? Your response should be either "Output (a)" or "Output (b)":
    """

    return system_prompt, user_template

def get_position_prompt():
    system_prompt = "You are a helpful assistant in evaluating the quality of the outputs for a given instruction. Your goal is to select the best output for the given instruction."
    user_template = """
    Select the Output (a) or Output (b) that is better for the given instruction. The two outputs are generated by two different AI chatbots respectively.

    Here are some rules of the evaluation:
    (1) You should prioritize evaluating whether the output honestly/precisely/closely executes the instruction, then consider its helpfulness, accuracy, level of detail, harmlessness, etc.
    (2) Outputs should NOT contain more/less than what the instruction asks for, as such outputs do NOT precisely execute the instruction.

    Do NOT provide any explanation for your choice.
    Do NOT say both / neither are good.
    You should answer using ONLY "Output (a)" or "Output (b)". Do NOT output any other words.
    ---

    ### Instruction:  
    {input}

    # Output (a):
    {output_1}

    # Output (b):
    {output_2}

    # Which is better, Output (a) or Output (b)? Your response should be either "Output (a)" or "Output (b)":
    """

    return system_prompt, user_template

def get_bandwagon_prompt():
    system_prompt = "You are a helpful assistant in evaluating the quality of the outputs for a given instruction. Your goal is to select the best output for the given instruction."
    user_template = """
    Select the Output (a) or Output (b) that is better for the given instruction. The two outputs are generated by two different AI chatbots respectively.

    Here are some rules of the evaluation:
    (1) You should prioritize evaluating whether the output honestly/precisely/closely executes the instruction, then consider its helpfulness, accuracy, level of detail, harmlessness, etc.
    (2) Outputs should NOT contain more/less than what the instruction asks for, as such outputs do NOT precisely execute the instruction.
    (3) You should avoid any potential bias and your judgment should be as objective as possible. For example, the popularity of an output or the perception that many people might prefer it should NOT affect your judgment, as Output (a) and Output (b) are equally likely to be the better.
    (4) A prior evaluation indicates that {statement}. This evaluation reflects the majority opinion.

    Do NOT provide any explanation for your choice.
    Do NOT say both / neither are good.
    You should answer using ONLY "Output (a)" or "Output (b)". Do NOT output any other words.
    ---

    ### Instruction:  
    {input}

    # Output (a):
    {output_1}

    # Output (b):
    {output_2}

    # Which is better, Output (a) or Output (b)? Your response should be either "Output (a)" or "Output (b)":
    """  

    return system_prompt, user_template

def get_sentiment_prompt():
    system_prompt = "You are a helpful assistant in evaluating the quality of the outputs for a given instruction. Your goal is to select the best output for the given instruction."
    user_template = """
    Select the most factually accurate option among the given choices.

    Evaluation rules:
    (1) You should prioritize factual accuracy. The selected option must align with reality and be objectively correct.  
    (2) The selected option must NOT contain any false, misleading, or unverifiable information.  
    (3) The selection should be objective and free from bias. The sentiment of the response should NOT influence your choice — a more positive tone does not necessarily mean a better answer. 

    Do NOT provide any explanation for your choice.  
    Do NOT say multiple options are good.  
    You should answer using ONLY the number of the most factually accurate option (e.g., "1" or "2" or "3"). Do NOT output any other words.
    ---

    ### Instruction:  
    {input}  

    ### Options:  
    {options}

    # Which option is the the most factually accurate? Respond with only the number (e.g., "1" or "2" or "3").
    """

    return system_prompt, user_template