# Copyright (c) Meta Platforms, Inc. and affiliates.
# All rights reserved.
#
# This source code is licensed under the license found in the
# LICENSE file in the root directory of this source tree.

import os

from ..abc import EnvBase

from .dmc2gym.wrappers import DMCWrapper


def make_env(spec: str, observation_output_kind: EnvBase.ObsOutputKind, seed,
             max_episode_length, action_repeat, batch_shape):
    # avoid circular imports
    from ..utils import make_batched_auto_reset_env, get_kinetics_dir

    domain_name, task_name = spec.split('_', maxsplit=1)
    if domain_name == "ball":
        domain_spec, task_name = task_name.rsplit('_', maxsplit=1)
        domain_name = domain_name + '_' + domain_spec

    kwargs = dict(
        domain_name=domain_name,
        task_name=task_name,
        observation_output_kind=observation_output_kind,
        frame_skip=action_repeat,
        total_frames=1000,
        height=64,
        width=64,
        episode_length=max_episode_length,
        # others
        camera_id=0,
        environment_kwargs=None,
        task_kwargs={},
        visualize_reward=False,
    )

    return make_batched_auto_reset_env(
        lambda seed: DMCWrapper(seed=seed, **kwargs),
        seed, batch_shape)


__all__ = ['make_env']
