
import random
import torch
import torchvision.transforms.functional as TF

class DiscreteRotation:
    def __init__(self, angle_steps):
        # devive the angle between 0 - 360 in angle_steps
        self.angles = [i * (360 // angle_steps) for i in range(angle_steps)]

    def __call__(self, img):
        angle = random.choice(self.angles)
        return TF.rotate(img, angle)