
def subsample(group_size: int,
            group_type: str,
            group_generator: str,
            subgroup_type: str,
            subsampling_factor: int):
    nodes = [i for i in range(group_size)]
    if group_type == 'dihedral':
        if subgroup_type == 'dihedral':
            assert group_generator == 'r-s'
            sub_sample_nodes = nodes[::subsampling_factor]
        elif subgroup_type == 'adihedral':
            assert group_generator == 'r-s'
            sub_sample_nodes = nodes[:group_size//2:subsampling_factor] + nodes[group_size//2 +1::subsampling_factor]
        elif subgroup_type == 'cycle':
            assert subsampling_factor% 2 == 0
            assert (group_size //2) % (subsampling_factor // 2) == 0    
            subsampling_factor = subsampling_factor // 2
            nodes = nodes[: group_size//2]
            sub_sample_nodes = nodes[::subsampling_factor]
        else:
            raise NotImplementedError
    elif group_type == 'cycle':
        sub_sample_nodes = nodes[::subsampling_factor]
    else:
        raise NotImplementedError
    return sub_sample_nodes
        
