import numpy as np

dimension = 30
p_xdim = 10
p_ydim = 10
population = p_xdim * p_ydim
input_bias = 0*np.ones((population, dimension))

def cec_fun1(input_x,input_bias):
    # flag = False
    # if len(input_x.shape) > 1:
    #     input_x = np.reshape(input_x,[-1,population,1,dimension])
    #     flag = True
    # else:
    #     input_x = np.reshape(input_x,[-1,1,1,dimension])
    input_bias = input_bias*np.ones((input_x.shape[0], input_x.shape[1]))
    input_x = input_x - input_bias
    result = np.sum(np.multiply(input_x,input_x),axis=1)
    return result
    # if flag:
    #     return np.reshape(result, [-1, p_xdim, p_ydim, 1])
    # else:
    #     return result



def cec_fun2(input_x,input_bias):
    # flag = False
    # if len(input_x.shape) > 1:
    #     input_x = np.reshape(input_x,[-1,population,1,dimension])
    #     flag = True
    # else:
    #     input_x = np.reshape(input_x,[-1,1,1,dimension])
    input_bias = input_bias * np.ones((input_x.shape[0], input_x.shape[1]))
    input_x = input_x - input_bias
    result = np.max(np.abs(input_x), axis=1)
    return result
    # if flag:
    #     return np.reshape(result, [-1, p_xdim, p_ydim, 1])
    # else:
    #     return result

def cec_fun3(input_x,input_bias):
    # flag = False
    # if len(input_x.shape) > 1:
    #     input_x = np.reshape(input_x,[-1,population,1,dimension])
    #     flag = True
    # else:
    #     input_x = np.reshape(input_x,[-1,1,1,dimension])
    input_bias = input_bias * np.ones((input_x.shape[0], input_x.shape[1]))
    input_x = input_x - input_bias
    p1 = 100*np.power(np.multiply(input_x[...,:-1],input_x[...,:-1])-input_x[...,1:],2)  #(x1^2-x2)^2
    p2 = np.power(input_x[...,:-1]-1,2)  #(x2-1)^2
    result = np.sum(p1+p2,axis=1)  #p1+p2
    return result
    # if flag:
    #     return np.reshape(result, [-1, p_xdim, p_ydim, 1])
    # else:
    #     return result

def cec_fun4(input_x,input_bias):
    # flag = False
    # if len(input_x.shape) > 1:
    #     input_x = np.reshape(input_x, [-1, population, 1, dimension])
    #     flag = True
    # else:
    #     input_x = np.reshape(input_x, [-1, 1, 1, dimension])
    input_bias = input_bias * np.ones((input_x.shape[0], input_x.shape[1]))
    input_x = input_x - input_bias
    a = np.multiply(input_x,input_x)
    b = 10*np.cos(2*np.pi*input_x)
    result = np.sum(a-b+10,axis=1)
    return result
    # if flag:
    #     return np.reshape(result, [-1, p_xdim, p_ydim, 1])
    # else:
    #     return result

def cec_fun5(input_x,input_bias):
    # flag = False
    # if len(input_x.shape) > 1:
    #     input_x = np.reshape(input_x, [-1, population, 1, dimension])
    #     flag = True
    # else:
    #     input_x = np.reshape(input_x, [-1, 1, 1, dimension])
    input_bias = input_bias * np.ones((input_x.shape[0], input_x.shape[1]))
    input_x = input_x - input_bias
    a = np.multiply(input_x, input_x)/4000
    const = np.array([i+1 for i in range(dimension)])
    const = np.expand_dims(const,0)
    const = np.tile(const,[input_x.shape[0],1])
    b = np.cos(np.divide(input_x,np.sqrt(const)))
    result = np.sum(a,axis=1)-np.prod(b,axis=1)+1
    return result
    # if flag:
    #     return np.reshape(result, [-1, p_xdim, p_ydim, 1])
    # else:
    #     return result

def cec_fun6(input_x,input_bias):
    # flag = False
    # if len(input_x.shape) > 1:
    #     input_x = np.reshape(input_x, [-1, population, 1, dimension])
    #     flag = True
    # else:
    #     input_x = np.reshape(input_x, [-1, 1, 1, dimension])
    input_bias = input_bias * np.ones((input_x.shape[0], input_x.shape[1]))
    input_x = input_x - input_bias
    a = -20*np.exp(-0.2*np.sqrt(1.0/dimension*np.sum(np.multiply(input_x,input_x),axis=1)))
    b = np.exp(1.0/dimension*np.sum(np.cos(2*np.pi*input_x),axis=1))
    result = a-b+20+np.e
    return result
    # if flag:
    #     return np.reshape(result, [-1, p_xdim, p_ydim, 1])
    # else:
    #     return result

##############################################################################################
test_functions = [cec_fun1,cec_fun2,cec_fun3,cec_fun4,cec_fun5,cec_fun6]

