import os
import random
import torch
import numpy as np

def set_random_seed(seed=42):
    torch.manual_seed(seed)#torch的cpu随机性
    torch.cuda.manual_seed_all(seed)#torch的gpu随机性
    torch.backends.cudnn.benchmark = False#保证gpu每次都选择相同的算法，但是不保证该算法是deterministic的。
    torch.backends.cudnn.deterministic = True#紧接着上面，保证算法是deterministic的。
    np.random.seed(seed)#np的随机性。
    random.seed(seed)#python的随机性。
    os.environ['PYTHONHASHSEED'] = str(seed)#设置python哈希种子，有人不知道这个是干啥的，
    #python里面有很多使用哈希算法完成的操作，例如对于一个数字的列表，使用set()来去重。
    #大家应该经历过，得到的结果中，顺序可能不一样，例如(1,2,3)(3,2,1)。
    #有时候需要在终端就把这个固定执行，到脚本实行有可能会迟。

set_random_seed(42)

print(torch.randn((1,3)))
print(torch.randn((1,3)))