from matplotlib import pyplot as plt
import numpy as np
import os

def draw(fid='f_3',root='./fitlist',dim=10,pt=-1):
    dir=os.path.join(root,'dim'+str(dim))
    cmaes=np.load('./fitlist/cma-es_f_7_dim12_pop_5.npy')
    es=np.load('./fitlist/es_f_7_dim_12_pop_5.npy')
    de=np.load('./fitlist/de_f_7_dim_12_pop_5.npy')
    # detn=np.load(os.path.join(dir,'detnws30_em30_ws1_%s.npy')%fid)
    plt.figure(figsize=(12,8))
    plt.title('Convergence Trend on Fun-6')
    plt.plot([i for i in range(len(cmaes))],cmaes,label='CMA-ES',c='darkorange')
    plt.plot([i for i in range(len(es))],es,label='ES',c='g')
    plt.plot([i for i in range(len(de))],de,label='DE',c='b')
    # plt.plot([i for i in range(len(detn))],detn,label='optFormer',c='r',marker='.')
    plt.legend(prop={'size':8})
    plt.savefig('./imgs/ConverenceCmp/%s.png'%fid)
    plt.savefig('./imgs/ConverenceCmp/%s.svg'%fid)
    
    
    
if __name__=='__main__':
    draw()