# Optformer

## requirements

Please refer to the requirements. txt  

Run the following command to install the runtime environment:

```
pip install -r requirements.txt
```

## Main files and directories

*ckpt/* : A directory that saves model parameters  

*data_protein/*: data set directory of protein Dock experiments

*IMGS /* : the directory saves the image generated by running the algorithm

*convex_torch.py* : implements protein Dock evaluation methods

*detn.py* : implementation of the Optformer 

*funtionset.py* : implementation of the F1~F9 functions based on pytorch

*np_fuctions.py* : numpy-based implementation of F1 to F9 functions

*train.py* : the main file  

 


## Training and testing

To train and test on F1 to F3, run the following command:
```
python ./train.py -probelm=functions -maxEpoch=<int>

eg:
python ./train.py -probelm=functions -maxEpoch=1000
```

To run a protein Dock instance, run the following command:

```
python ./train.py -probelm=protein -maxEpoch=<int>

eg:
python ./train.py -probelm=protein -maxEpoch=1000
```
For detailed parameter design information, refer to the parameter comments in the train.py file.



