from utils import get_optimal_actions, run_experiment, get_random_actions
import pandas as pd
import numpy as np
from models.thompson import Thompson
import os
import sys

MIN_REWARD = 0
MAX_REWARD = 100
N_RUNS = 250
NUM_POSSIBLE_ACTIONS = 50
VALUE = sys.argv[1] # value name OR simulated

actions, real_scores = get_random_actions(NUM_POSSIBLE_ACTIONS, MAX_REWARD, MIN_REWARD)
if VALUE != 'simulated':
    data = pd.read_csv('./data/justice_50_actions_with_values.csv')  
    actions = np.array([int(i) for i in range(NUM_POSSIBLE_ACTIONS)]).astype(int)
    real_scores = list(data[VALUE + '_score'])
    
real_optimal_actions = get_optimal_actions(NUM_POSSIBLE_ACTIONS, actions, real_scores)

# List of metrics to track
metrics = ['mean_reward', 'unique_actions_taken', 'non_optimal_actions_taken', 'negative_actions_taken',
           'iterations_to_convergence']


for run in range(N_RUNS):
    action_data, score_data = [], []

    # Run experiment.
    model = Thompson(actions, MAX_REWARD)

    path = './data/thompson_baseline/' + VALUE + '/'
    if not os.path.exists(path):
        os.makedirs(path)

    single_run_metrics = run_experiment(actions, action_data, score_data, real_scores,
                                        real_optimal_actions, model, n_allowed_actions=10, immoral_threshold=50, 
                                        allowed_actions='allowed_actions_1k_train.txt',
                                        max_iterations = 1000, 
                                        history_filename=path + 'run_' + str(run) + ".csv")

    # Save out metrics from this individual run
    for metric in single_run_metrics.keys():
        # Put in a list so it can be parsed to a DataFrame row
        single_run_metrics[metric] = [single_run_metrics[metric]]

    trial = pd.DataFrame(single_run_metrics, columns=metrics)
    filename = path + '/run_data.csv'
    if os.path.exists(filename):
        run_metrics = pd.concat([pd.read_csv(filename), trial])
    else:
        run_metrics = trial
    run_metrics.to_csv(filename, index=False)
    
