# File to define various kernel functions. 
import numpy as np

# Kernel selection function
def SelectKernel(kernel_string):
    if kernel_string == "L1":
        return L1Norm
    if kernel_string == "L2":
        return L2Norm
    if kernel_string == "RBF":
        return RBF
    if kernel_string == "SE":
        return SquaredExponential


def L1Norm(a, b):
    return abs(a-b)


def L2Norm(a, b):
    return np.sqrt(a * a + b * b)


def RBF(a, b, sigma=1):
    return np.exp(-1 * L2Norm(a, b) / (2 * sigma * sigma))


def SquaredExponential(a, b, length_scale=1):
    return np.exp(-1 * L1Norm(a, b) * L1Norm(a, b) / (2 * length_scale * length_scale))
