# Information-Theoretic GAN Compression with Variational Energy-based Model

## Prerequisites

* Linux
* Python 3
* CPU or NVIDIA GPU + CUDA CuDNN

## Getting Started

### Installation

- Install dependencies.

  ```shell
  conda create -n VEM python=3.7
  conda activate VEM
  pip install torch==1.7.0 torchvision==0.8.0 torchaudio==0.7.0 
  pip install -r requirements.txt 
  ```

### Data preparation

- edges2shoes

    - Download the dataset
    ```shell
    bash datasets/download_pix2pix_dataset.sh edges2shoes-r
    ```
  
    - Get the statistical information for the ground-truth images for your dataset to compute FID. 
    ```shell
    bash datasets/download_real_stat.sh edges2shoes-r B
    ```
    
- cityscapes
    
    - Download the dataset 
    Download the dataset (*gtFine_trainvaltest.zip* and *leftImg8bit_trainvaltest.zip*) from [here](https://cityscapes-dataset.com), and preprocess it. 
    ```shell
    python datasets/get_trainIds.py database/cityscapes-origin/gtFine/
    python datasets/prepare_cityscapes_dataset.py \
    --gtFine_dir database/cityscapes-origin/gtFine \
    --leftImg8bit_dir database/cityscapes-origin/leftImg8bit \
    --output_dir database/cityscapes \
    --train_table_path datasets/train_table.txt \
    --val_table_path datasets/val_table.txt
    ```
      
    - Get the statistical information for the ground-truth images for your dataset to compute FID. 
    ```shell
    bash datasets/download_real_stat.sh cityscapes A
    ```

### Pretrained Model
Please download the DRN model(drn-d-105_ms_cityscapes.pth) which acn be used to compute mIOU [link](https://drive.google.com/drive/folders/0B_4LoEXGO1TwcmhzLXpWUVFEMXM?resourcekey=0-PMTQHtlWMtSBYozjajFLXA).
The pretrained model should be in this directory. 

### Training

- train student model using OMGD
  Run the following script to train a unet-style student on cityscapes dataset, 
  all scripts for cyclegan and pix2pix on horse2zebra,,edges2shoes and cityscapes can be found in ./scripts
  
  ex)
  - U-Net_pix2pix tested on the cityscapes dataset
  ```shell
  bash scripts/unet_pix2pix/cityscapes/distill.sh 
  ```

- train student model using OMGD with VEM
  Run the following script to train a unet-style student on cityscapes dataset, 
  all scripts for cyclegan and pix2pix on horse2zebra,edges2shoes and cityscapes can be found in ./scripts

  ex)
  - U-Net_pix2pix tested on the cityscapes dataset
  ```shell
  bash scripts/unet_pix2pix/cityscapes/mi_distill.sh 
  ```

## Acknowledgments
The code is developed based on [OMGD](https://github.com/bytedance/OMGD)
