import math

import pickle
import numpy as np
from scipy.stats import norm
eps = [0.002, 0.004, 0.006, 0.008, 0.01]
print('-----------------------------------------------------------------')
print('ASPPO')
print('walker')
for e in eps:
    total_q = []
    p = norm.cdf(norm.ppf(0.5 - 0.0387) - e * math.sqrt(1000) / 0.2)
    for i in range(15):
        with open('adv_ppo_walker/agents/walker_smoothing_adv_'+str(i+1)+'.model/attack-none-eps-same/rewards.pkl', 'rb') as f:
            r = pickle.load(f)
        total_q.append(np.quantile(r, p))
    print(np.median(total_q))
print('hopper')
for e in eps:
    total_q = []
    p = norm.cdf(norm.ppf(0.5 - 0.0387) - e * math.sqrt(1000) / 0.3)
    for i in range(15):
        with open('adv_ppo_hopper/agents/hopper_smoothing_adv_'+str(i+1)+'.model/attack-none-eps-same/rewards.pkl', 'rb') as f:
            r = pickle.load(f)
        total_q.append(np.quantile(r, p))
    print(np.median(total_q))
print('humanoid')
for e in eps:
    total_q = []
    p = norm.cdf(norm.ppf(0.5 - 0.0387) - e * math.sqrt(1000) / 0.4)
    for i in range(15):
        with open('adv_ppo_humanoid/agents/humanoid_smoothing_adv_'+str(i+1)+'.model/attack-none-eps-same/rewards.pkl', 'rb') as f:
            r = pickle.load(f)
        total_q.append(np.quantile(r, p))
    print(np.median(total_q))
print('-----------------------------------------------------------------')
print('SPPO')
print('walker')
for e in eps:
    total_q = []
    p = norm.cdf(norm.ppf(0.5 - 0.0387) - e * math.sqrt(1000) / 0.2)
    for i in range(15):
        with open('rs_ppo_walker/agents/walker_rs_'+str(i+1)+'.model/attack-none-eps-same/rewards.pkl', 'rb') as f:
            r = pickle.load(f)
        total_q.append(np.quantile(r, p))
    print(np.median(total_q))
print('hopper')
for e in eps:
    total_q = []
    p = norm.cdf(norm.ppf(0.5 - 0.0387) - e * math.sqrt(1000) / 0.3)
    for i in range(15):
        with open('rs_ppo_hopper/agents/hopper_rs_'+str(i+1)+'.model/attack-none-eps-same/rewards.pkl', 'rb') as f:
            r = pickle.load(f)
        total_q.append(np.quantile(r, p))
    print(np.median(total_q))
print('humanoid')
for e in eps:
    total_q = []
    p = norm.cdf(norm.ppf(0.5 - 0.0387) - e * math.sqrt(1000) / 0.4)
    for i in range(15):
        with open('rs_ppo_humanoid/agents/humanoid_rs_'+str(i+1)+'.model/attack-none-eps-same/rewards.pkl', 'rb') as f:
            r = pickle.load(f)
        total_q.append(np.quantile(r, p))
    print(np.median(total_q))
print('-----------------------------------------------------------------')
print('sgld+rs')
print('walker')
with open('sgld_walker/agents/model-sappo-sgld-walker-median.model/attack-none-eps-same/rewards.pkl', 'rb') as f:
    r = pickle.load(f)
for e in eps:
    p = norm.cdf(norm.ppf(0.5 - 0.0387) - e * math.sqrt(1000) / 0.2)
    print(np.quantile(r, p))
print('hopper')
with open('sgld_hopper/agents/model-sappo-sgld-hopper-median.model/attack-none-eps-same/rewards.pkl', 'rb') as f:
    r = pickle.load(f)
for e in eps:
    p = norm.cdf(norm.ppf(0.5 - 0.0387) - e * math.sqrt(1000) / 0.3)
    print(np.quantile(r, p))
print('humanoid')
with open('sgld_humanoid/agents/model-sappo-sgld-humanoid-median.model/attack-none-eps-same/rewards.pkl', 'rb') as f:
    r = pickle.load(f)
for e in eps:
    p = norm.cdf(norm.ppf(0.5 - 0.0387) - e * math.sqrt(1000) / 0.4)
    print(np.quantile(r, p))
print('-----------------------------------------------------------------')
print('convex+rs')
print('walker')
with open('convex_walker/agents/model-sappo-convex-walker-median.model/attack-none-eps-same/rewards.pkl', 'rb') as f:
    r = pickle.load(f)
for e in eps:
    p = norm.cdf(norm.ppf(0.5 - 0.0387) - e * math.sqrt(1000) / 0.2)
    print(np.quantile(r, p))
print('hopper')
with open('convex_hopper/agents/model-sappo-convex-hopper-median.model/attack-none-eps-same/rewards.pkl', 'rb') as f:
    r = pickle.load(f)
for e in eps:
    p = norm.cdf(norm.ppf(0.5 - 0.0387) - e * math.sqrt(1000) / 0.3)
    print(np.quantile(r, p))
print('humanoid')
with open('convex_humanoid/agents/model-sappo-convex-humanoid-median.model/attack-none-eps-same/rewards.pkl', 'rb') as f:
    r = pickle.load(f)
for e in eps:
    p = norm.cdf(norm.ppf(0.5 - 0.0387) - e * math.sqrt(1000) / 0.4)
    print(np.quantile(r, p))
print('-----------------------------------------------------------------')
print('vanilla+rs')
print('walker')
with open('vanilla_ppo_walker/agents/model-ppo-walker-median.model/attack-none-eps-same/rewards.pkl', 'rb') as f:
    r = pickle.load(f)
for e in eps:
    p = norm.cdf(norm.ppf(0.5 - 0.0387) - e * math.sqrt(1000) / 0.2)
    print(np.quantile(r, p))
print('hopper')
with open('vanilla_ppo_hopper/agents/model-ppo-hopper-median.model/attack-none-eps-same/rewards.pkl', 'rb') as f:
    r = pickle.load(f)
for e in eps:
    p = norm.cdf(norm.ppf(0.5 - 0.0387) - e * math.sqrt(1000) / 0.3)
    print(np.quantile(r, p))
print('humanoid')
with open('vanilla_ppo_humanoid/agents/model-ppo-humanoid-median.model/attack-none-eps-same/rewards.pkl', 'rb') as f:
    r = pickle.load(f)
for e in eps:
    p = norm.cdf(norm.ppf(0.5 - 0.0387) - e * math.sqrt(1000) / 0.4)
    print(np.quantile(r, p))