import subprocess
import torch
import os

def get_response_list_from_vicuna(messages_list,
                                  model="vicuna-13b-v1.5-16k",
                                  save_file_name=None,
                                  num_gpus=4, 
                                  max_gpu_memory=8,
                                  temperature=0):
    assert save_file_name is not None
    model = 'lmsys/' + model
    # TODO: lock file to avoid race condition?
    file_path = os.path.expanduser('~') + f'/tmp_messages_list_from_{save_file_name}.pt' # in home directory, fixed path, can be changed
    torch.save(messages_list, file_path)
    print(f'Waiting for the file to be saved in {file_path}...')
    while True:
        if os.path.exists(file_path):
            break
    print('File saved!')
    # TODO: if there's not bug, rename vicuna_setup.sh as fastchat_setup.sh
    subprocess.run(f"./fastchat_setup.sh {model} {temperature} {save_file_name} {num_gpus} {max_gpu_memory}", shell=True, check=True)


def get_response_list_from_llama_2(messages_list,
                                  model="Llama-2-13b-chat-hf",
                                  save_file_name=None,
                                  num_gpus=4, 
                                  max_gpu_memory=8,
                                  temperature=0):
    assert save_file_name is not None
    model = 'meta-llama/' + model
    # TODO: lock file to avoid race condition?
    file_path = os.path.expanduser('~') + f'/tmp_messages_list_from_{save_file_name}.pt' # in home directory, fixed path, can be changed
    torch.save(messages_list, file_path)
    print(f'Waiting for the file to be saved in {file_path}...')
    while True:
        if os.path.exists(file_path):
            break
    print('File saved!')
    subprocess.run(f"./fastchat_setup.sh {model} {temperature} {save_file_name} {num_gpus} {max_gpu_memory}", shell=True, check=True)