import torch

def load_result_pt(templates_list_daily_dialog, data_split, pt_file_path, rewrite_i, is_trim=False, do_ablation=False, single_turn=False, extract_answer=False, insert_new_info=False, exclude_tc=False):
    dd_result = {
                "t1-tc-tp-ti": [[] for _ in range(len(templates_list_daily_dialog))],
                "t1-tp-tc-ti": [[] for _ in range(len(templates_list_daily_dialog))]
                }
    if single_turn:
        do_ablation = "single_turn_"
    else:
        if not do_ablation:
            if is_trim:
                do_ablation = "trim_"
            else:
                do_ablation = ""
        else:
            do_ablation = "ablation_"
    if extract_answer:
        assert not is_trim and not do_ablation and not single_turn
        do_ablation = "i_i2_"
    if insert_new_info:
        assert not is_trim and not do_ablation and not single_turn
        if exclude_tc:
            do_ablation = "insert_exclude_tc_" # "insert_exclude_tc_reverse_"
        else:
            assert not exclude_tc
            do_ablation = "insert_" # "insert_reverse_"
    for method in ["t1-tc-tp-ti", "t1-tp-tc-ti"]:
        for i in range(len(templates_list_daily_dialog)):
            if method == "t1-tc-tp-ti":
                if rewrite_i is None:
                    print(f"You did not specify rewrite_i, will try to load coqa_{data_split}_yes_no_rewrite_c{i}_p_chatgpt.pt. Either explicitly mention rewrite_i or maybe you forgot to set --report_concise flag")
                    data = torch.load(f'{pt_file_path}/coqa_{data_split}_yes_no_rewrite_c{i}_p_chatgpt.pt')
                elif rewrite_i in [0, 1, 2]:
                    data = torch.load(f'{pt_file_path}/coqa_{data_split}_yes_no_mturk_rewrite_{rewrite_i}_c{i}_p_{do_ablation}chatgpt.pt')
                    print(f'Successfully load {pt_file_path}/coqa_{data_split}_yes_no_mturk_rewrite_{rewrite_i}_c{i}_p_{do_ablation}chatgpt.pt!')
                else:
                    print("Should not be here...")
                    assert False
                dd_result[method][i] = data
            else:
                assert method == "t1-tp-tc-ti"
                if rewrite_i is None:
                    data = torch.load(f'{pt_file_path}/coqa_{data_split}_yes_no_rewrite_p_c{i}_chatgpt.pt')
                elif rewrite_i in [0, 1, 2]:
                    data = torch.load(f'{pt_file_path}/coqa_{data_split}_yes_no_mturk_rewrite_{rewrite_i}_p_c{i}_{do_ablation}chatgpt.pt')
                    print(f'Successfully load {pt_file_path}/coqa_{data_split}_yes_no_mturk_rewrite_{rewrite_i}_p_c{i}_{do_ablation}chatgpt.pt!')
                else:
                    print("Should not be here...")
                    assert False
                dd_result[method][i] = data
    return dd_result
