import os
from time import sleep

import backoff
import openai
from openai import OpenAI

client = OpenAI(api_key=os.environ["OPENAI_API_KEY_XXX"])
#from openai.error import RateLimitError, InvalidRequestError # newly added
from tqdm import tqdm


@backoff.on_exception(backoff.expo, openai.RateLimitError)
def chatcompletions_with_backoff(**kwargs):
    response = client.chat.completions.create(**kwargs)
    return response

def get_error_messages_list():
    return ["Invalid Request Error"]

def get_response_list_from_chatgpt(messages_list,
                                   model="gpt-3.5-turbo-0125",
                                   temperature=0,
                                   max_tokens=128):
    response_list = []
    for messages in tqdm(messages_list) if len(messages_list) > 1 else messages_list:
        not_processed = True
        while not_processed:
            try:
                response = chatcompletions_with_backoff(
                    model=model, # "gpt-3.5-turbo", "gpt-3.5-turbo-0301", etc.
                    messages=messages,
                    temperature=temperature,
                    max_tokens=max_tokens,
                    top_p=1,
                    frequency_penalty=0,
                    presence_penalty=0,
                )
                not_processed = False
            except openai.BadRequestError as e: # newly added
                response = "Invalid Request Error" # newly added, should be appeared in get_error_messages_list()
                not_processed = False # newly added
                tqdm.write(f"{str(e)}") # newly added
            except:
                not_processed = True
                tqdm.write("Some error occurs, sleep 30 seconds..")
                sleep(30)
            finally:
                pass
        response_list.append(response)
    return response_list
