SIGN = "sign"
SQRT = "sqrt"
INV = "inv"
PROOT = "proot"
RESHAPE = "reshape"


def _sign(tag: str) -> str:
    """Return canonical key for a *sign* action."""
    return f"sign_{tag}"


def _sqrt(tag: str) -> str:
    """Return canonical key for a *sqrt* action."""
    return f"sqrt_{tag}"


def _inv(tag: str) -> str:
    """Return canonical key for an *inverse* action."""
    return f"inv_{tag}"

def _proot(tag: str) -> str:
    """Return canonical key for an *1/3 root* action."""
    return f"proot_{tag}"

MATRIX_FUNCTIONS = [SIGN, SQRT, INV, PROOT]


# %% algorithms
MCTS = "mcts"
