"""
A dictionary of possible choices for schedules for the MCTS exploration constant C.
"""

from utils import export

EXPLORATION_SCHEDULES = {}


@export(EXPLORATION_SCHEDULES)
def exponential(t, max_t, max_c, min_c, **kwargs):
    """
    Exponential decay schedule for the exploration constant C.
    """
    c = max_c * (min_c / max_c) ** (t / max_t)
    return c


@export(EXPLORATION_SCHEDULES)
def constant(t, C, **kwargs):
    """
    Constant schedule for the exploration constant C.
    """
    return C
