from sorcerun.git_utils import (
    is_dirty,
    get_repo,
    get_commit_hash,
    get_time_str,
    get_tree_hash,
)

repo = get_repo()

make_algorithm_hash = get_tree_hash(repo, "make_algorithm")
test_algorithm_hash = get_tree_hash(repo, "test_algorithm")

test_mat_name = "wishart"
test_mat_config = dict(
    c=0.25,
    d=1000,
    eps=1e-3,
)

loss_type = "l2"
loss_args = [0.1]

config = {
    "loss_type": loss_type,
    "loss_args": loss_args,
    #
    "test_mat_name": test_mat_name,
    "test_mat_config": test_mat_config,
    #
    "make_algorithm_hash": make_algorithm_hash,
    #
    "commit_hash": get_commit_hash(repo),
    "test_algorithm_hash": test_algorithm_hash,
    "time_str": get_time_str(),
    "dirty": is_dirty(get_repo()),
    "experiment_name": "test_algorithm",
}
