import os

from sorcerun.git_utils import (
    is_dirty,
    get_repo,
    get_commit_hash,
    get_time_str,
    get_tree_hash,
)

from sorcerun.incense_utils import (
    get_latest_single_and_grid_exps,
    load_filesystem_expts_by_config_keys,
)

import sys

repo = get_repo()
ROOT = repo.working_dir
if ROOT not in sys.path:
    sys.path.append(ROOT)

from globals import SIGN, SQRT, INV, PROOT

make_algorithm_hash = get_tree_hash(repo, "make_algorithm")
test_algorithm_hash = get_tree_hash(repo, "test_algorithm")

test_mat_name = "wishart"
test_mat_config = dict(
    c=0.5,
    d=1500,
    eps=1e-6,
)

algorithm_name = "mcts"
matrix_function = SQRT
device = "cuda"
precision = "double"
custom_loss = False

make_exps = load_filesystem_expts_by_config_keys(
    f"{repo.working_dir}/file_storage/runs",
    make_algorithm_hash=make_algorithm_hash,
    experiment_name="make_algorithm",
    #algorithm_name=algorithm_name
)
# get single and grid experiments once in this file for efficiency
make_exp, make_grid_exps = get_latest_single_and_grid_exps(make_exps)

print(
    "In test_algo_config.py: ",
    f"Found {len(make_grid_exps)} make_algorithm experiments with hash {make_algorithm_hash}",
)

if make_exp is None:
    make_algorithm_run_id = None
    print("No single make_algorithm experiment found.")
else:
    make_algorithm_run_id = make_exp.id
    print(
        "In test_algo_config.py: ",
        f"Found single make_algorithm experiment with hash "
        + f"{make_algorithm_hash} with id {make_exp.id}",
    )

config = {
    "matrix_function": matrix_function,
    "device": device,
    #
    "test_mat_name": test_mat_name,
    "test_mat_config": test_mat_config,
    #
    "make_algorithm_hash": get_tree_hash(repo, "make_algorithm"),
    "make_algorithm_run_id": make_algorithm_run_id,
    #
    "commit_hash": get_commit_hash(repo),
    "test_algorithm_hash": get_tree_hash(repo, "test_algorithm"),
    "time_str": get_time_str(),
    "dirty": is_dirty(repo),
    "experiment_name": "test_algorithm",
    #
    "precision": precision,
    'custom_loss': custom_loss,
    "seed": 42,
}
