import numpy as np
from sorcerun.git_utils import (
    is_dirty,
    get_repo,
    get_commit_hash,
    get_time_str,
    get_tree_hash,
)


import sys

repo = get_repo()
ROOT = repo.working_dir
if ROOT not in sys.path:
    sys.path.append(ROOT)

commit_hash = get_commit_hash(repo)
time_str = get_time_str()
dirty = is_dirty(repo)
grid_id = (f"{time_str}--{commit_hash}--dirty={dirty}",)


from test_algorithm.test_algo_config import config, make_grid_exps
from make_algorithm.make_algo_grid_config import init_mat_names, init_mat_sizes
from make_algorithm.make_algo_config import init_mat_config
from globals import SIGN, INV, SQRT, PROOT


def make_test_config(init_mat_name, init_mat_size, make_algorithm_exp, r):
    c = config.copy()
    ic = init_mat_config.copy()
    ic.update({"d": init_mat_size})
    c.update(
        {
            "make_algorithm_run_id": make_algorithm_exp.id,
            #
            "init_mat_name": init_mat_name,
            "init_mat_config": ic,
            #
            "matrix_function": make_algorithm_exp.config.matrix_function,
            #
            "commit_hash": commit_hash,
            "time_str": time_str,
            "dirty": dirty,
            "grid_id": grid_id,
            "repeat": r,
        },
    )
    return c


repeats = 1
configs = [
    make_test_config(init_mat_name, init_mat_size, e, r)
    for init_mat_name in init_mat_names
    for init_mat_size in (init_mat_sizes if init_mat_name != "CIFAR" else [3072])
    for e in make_grid_exps
    for r in range(repeats)
]

configs = [c for c in configs if c["matrix_function"] == SQRT]

seeds = 42 + np.arange(len(configs))
configs = [
    {
        **c,
        "seed": int(seed),
    }
    for c, seed in zip(configs, seeds)
]


print(f"Number of configs in test_algo_grid_config: {len(configs)}")
