# NeurIPS 2025 Code Submission — Buffer Layer for Test-Time Adaptation

This code submission contains a simplified version of the implementation used in our NeurIPS 2025 submission.

## Important Note

This code is **intended for reference and clarity**, and not as a fully standalone executable package. It is based on the exact implementation used to produce the results reported in the paper, but:

- Certain dependencies (e.g., data paths, pretrained model checkpoints, full environment configuration) have been omitted or abstracted for simplicity.
- As a result, this code is **not expected to run out-of-the-box**.
- However, **all core components and logic are faithfully included**, allowing researchers to understand and reimplement the method with minimal effort.

## What’s Included

- Modular implementation of the Buffer Layer architecture
- Configuration files for representative experiments (e.g., CIFAR10-C)


-This is meant to support transparency and reproducibility. While you may need to adjust certain parts (e.g., paths, dependencies, datasets) to run the code, the structure should make it straightforward to reproduce the core results or adapt the method to your own setting.


- For the sake of simplicity and clarity, **only two representative methods — Tent and Tent+Buffer — are included** in this submission.

-The experiments and code are based on a setting that builds upon an existing open-source GitHub repository. However, to preserve anonymity during the review process, we do not disclose the original repository also at this time. The full codebase and references will be made publicly available upon acceptance.