#!/bin/bash
#SBATCH --job-name=usr2
#SBATCH --partition={}
#SBATCH --gres=gpu:8
#SBATCH --ntasks-per-node=8
#SBATCH --cpus-per-task=12
#SBATCH --nodes=1
#SBATCH --time=00:00:00
#SBATCH --no-requeue

srun python main.py \
    experiment_name=base_low_resource_lrs3 \
    trainer.num_nodes=1 \
    optimizer.warmup_epochs=15 \
    trainer.max_epochs=50 \
    optimizer.base_lr=3e-3 \
    model.unlab_rel_weight_v=0.97 \
    model.unlab_rel_weight_a=0.75 \
    data.frames_per_gpu=4400 \
    data.frames_per_gpu_labelled=600 \
    model.backbone.drop_path=0.1 \
    checkpoint.dirpath={} \
    model.transfer_only_encoder=True \
    data.dataset.train_csv={} \
    data.dataset.train_labelled_csv={} \
    data.dataset.val_csv={} \
    data.dataset.test_csv={} \
    model/backbone=resnet_transformer_base \
    model.pretrained_model_path={}