#!/bin/bash
#SBATCH --job-name=usr2
#SBATCH --partition={}
#SBATCH --gres=gpu:8
#SBATCH --ntasks-per-node=8
#SBATCH --cpus-per-task=12
#SBATCH --nodes=4
#SBATCH --time=00:00:00
#SBATCH --no-requeue

srun python main.py \
    experiment_name=baseplus_high_resource_lrs3vox2 \
    trainer.num_nodes=4 \
    optimizer.warmup_epochs=15 \
    trainer.max_epochs=50 \
    optimizer.base_lr=2e-3 \
    model.unlab_rel_weight_v=0.7 \
    model.unlab_rel_weight_a=0.4 \
    data.frames_per_gpu=3200 \
    data.frames_per_gpu_labelled=1200 \
    model.backbone.drop_path=0.1 \
    checkpoint.dirpath={} \
    model.transfer_only_encoder=True \
    data.dataset.train_csv={} \
    data.dataset.train_labelled_csv={} \
    data.dataset.val_csv={} \
    data.dataset.test_csv={} \
    model/backbone=resnet_transformer_baseplus \
    model.pretrained_model_path={}