#!/bin/bash
#SBATCH --job-name=usr2
#SBATCH --partition={}
#SBATCH --gres=gpu:8
#SBATCH --ntasks-per-node=8
#SBATCH --cpus-per-task=12
#SBATCH --nodes=8
#SBATCH --time=00:00:00
#SBATCH --no-requeue

srun python main.py \
    experiment_name=huge_high_resource_lrs2lrs3vox2avsp \
    trainer.num_nodes=8 \
    optimizer.warmup_epochs=15 \
    trainer.max_epochs=50 \
    optimizer.base_lr=7e-4 \
    model.unlab_rel_weight_v=0.8 \
    model.unlab_rel_weight_a=0.5 \
    data.frames_per_gpu=2400 \
    data.frames_per_gpu_labelled=700 \
    model.backbone.drop_path=0.3 \
    checkpoint.dirpath={} \
    model.transfer_only_encoder=True \
    data.dataset.train_csv={} \
    data.dataset.train_labelled_csv={} \
    data.dataset.val_csv={} \
    data.dataset.test_csv={} \
    model/backbone=resnet_transformer_huge \
    model.pretrained_model_path={}