## FTAS ATTACK
Codes for reproducing query-efficient black-box attacks in  "Query Efficient Black-Box Adversarial Attack with Automatic Region Selection"

## Environmental version
1. System and Python version was obtained by paper.
2. Extral libraries are available from 'requirements.txt'.
 ```
    pip install -r requirements.txt
 ```

## Datasets
The dataset **CIFAR10** and **MNIST** would be downloaded automatically the first time you use them. If this fails, check the model_path in `config/dataset_and_model/*.yaml` and download by yourself.

For the **ImageNet** validation dataset please download the file using the following link: https://image-net.org/
Or you can use the images we provide at `datasets/imagenet/` folder.

If you have done the above work, you need to fill the `data_path` in the `config/dataset_and_model` folders.

## Run Attack
```
python main.py dataset_and_model=[mnist | cifar10 | imagenet] setup.algorithm.if_overlap=[overlapping | nonoverlapping] setup.algorithm.targeted=[targeted | untargeted] setup.algorithm.k=20 setup.algorithm.epsilon=[0.4 | 0.1]
```
You can set a smaller $k$ value as a initial value. $k$ is the number of groups to disturb. If you want to reproduce the code, you can refer to the file named `order`, which provided some instruction.

###### Attention!!!

Overlapping groups and nonoverlapping groups will result in different $\ell_0$ distances. To ensure a specific level of perturbation, please refer to the supplementary material. This section provides detailed information and instructions on how to control and maintain a desired level of perturbation in the context of overlapping and non-overlapping groups.

## File structure
- `main.py`: Entrance of our project.
- `attack.py`: The definition of our attack algorithm.
- `optimizer.py`: Some optimizer methods.
- `utils/general_utils.py`: General purpose toolkit.
- `config`: The folder of config files for datasets, models and hyperparameters.
- `datasets`: The folder of dataset source files, such as MNIST, CIFAR10, ImageNet.
- `Group`: Different preloaded grouping files, which will load in `attack.py`. (It can save much time. Or you can modify a variable named `setup.general_setup.load_pre_groups` as `False` to generate a group as you need.)
- `model_files`: The folder of pre-trained model files.
- `dataset_and_model` : The folder of dataset network model document.
- `requirements.txt`: Extral libraries.
- `order`: Command line instruction.
