# RMAAT: A Bio-Inspired Approach for Efficient Long-Context Sequence Processing in Transformers

## Overview

The quadratic complexity of the self-attention mechanism presents a significant impediment to applying Transformer models to long sequences. This work explores computational principles derived from astrocytes—glial cells critical for biological memory and synaptic modulation—as a complementary approach to conventional architectural modifications for efficient self-attention. We introduce the Recurrent Memory Augmented Astromorphic Transformer (RMAAT), an architecture integrating abstracted astrocyte functionalities. RMAAT employs a recurrent, segment-based processing strategy where persistent memory tokens propagate contextual information. An adaptive compression mechanism, governed by a novel retention factor derived from simulated astrocyte long-term plasticity (LTP), modulates these tokens. Attention within segments utilizes an efficient, linear-complexity mechanism inspired by astrocyte short-term plasticity (STP). Training is performed using Astrocytic Memory Replay Backpropagation (AMRB), an algorithm designed for memory efficiency in recurrent networks.

This repository contains the code for the experiments presented in our NeurIPS 2025 submission, "RMAAT: A Bio-Inspired Approach for Efficient Long-Context Sequence Processing in Transformers."

## Prerequisites

* Python 3.10 (as specified in `req_env_py_310.yml`)
* Conda (for environment management)
* PyTorch (specified in `req_env_py_310.yml`)
* CUDA (if GPU usage is intended). The environment file `req_env_py_310.yml` specifies `pytorch-cuda=11.7`. Ensure your system's CUDA toolkit is compatible.

## Setup

1.  **Extract the Code:**
    * For the review process, the code is provided as a supplementary zip file. Extract it to your desired location. This will create a folder, likely named `RMAAT_NeurIPS`.
    * Navigate into the codebase directory:
        ```bash
        cd RMAAT_NeurIPS
        ```

2.  **Create Conda Environment:**
    * **CRITICAL:** Before running the next command, **you MUST manually open the `req_env_py_310.yml` file (located in the `RMAAT_NeurIPS` directory) and REMOVE the last line that starts with `prefix: ...`**. This line is specific to the original author's machine (containing `/home/mxm6982/...`) and will prevent environment creation on other systems.
    * Once the `prefix` line is removed, create the environment from within the `RMAAT_NeurIPS` directory:
        ```bash
        conda env create -f req_env_py_310.yml
        conda activate py_310
        ```

3.  **Download Datasets:**
    * The script `get_lra_data.sh` (located in the `RMAAT_NeurIPS` directory) is provided to download datasets required for the Long Range Arena (LRA) benchmark (IMDb, CIFAR-10, ListOps, Pathfinder, AAN).
    * Run the script from the root of the `RMAAT_NeurIPS` directory:
        ```bash
        bash get_lra_data.sh
        ```
    * This will create a `datasets/` subdirectory within `RMAAT_NeurIPS` and populate it.
    * **VERY IMPORTANT FOR REVIEWERS:** The codebase may contain hardcoded absolute paths for dataset locations (e.g., including `/home/mxm6982/...`), particularly for the `aan` and `pathfinder32` datasets within `dataloader.py` and `lra_datasets.py`.
        * For successful execution, these paths **MUST be modified** to be relative (e.g., pointing to `./datasets/...` from within the `RMAAT_NeurIPS` directory) or made configurable through the `configs/config_v10.yaml` file.
        * Reviewers may need to manually adjust these paths in the specified Python files (`dataloader.py`, `lra_datasets.py`) to point to the correct locations within the `./datasets/` directory if they are not already relative or configurable. The configuration file `configs/config_v10.yaml` should ideally control these paths.

## Running the Code

The main script to initiate training is `run_train.py`. This script utilizes a configuration file located in the `configs/` subdirectory to set up the experiment.

The primary command to execute training (adapted from `run_train.txt`) from within the `RMAAT_NeurIPS` directory is:

```bash
CUDA_VISIBLE_DEVICES=0 python run_train.py --config configs/config_v10.yaml
```
 * CUDA_VISIBLE_DEVICES=0: Specifies the GPU to use (e.g., GPU ID 0). Adjust this if you have multiple GPUs or wish to use a different one. Remove this prefix if running on a CPU (though GPU is recommended, and ensure PyTorch is configured for CPU in that scenario).
 * --config configs/config_v10.yaml: Specifies the configuration file to use. 
 * The file configs/config_v10.yaml (relative to the RMAAT_NeurIPS directory) contains parameters for the dataset selection (e.g., imdb_lra, aan, listops), model architecture, training schedule, and other hyperparameters. 
 * Before running:Ensure the Conda environment py_310 is activated (conda activate py_310). 
 * Confirm that datasets have been downloaded using get_lra_data.sh into the datasets/ subdirectory. 
 * Crucially, verify that dataset paths within the code (dataloader.py, lra_datasets.py) and/or the configuration file (configs/config_v10.yaml) are correctly set to point to the downloaded data, preferably using relative paths from the RMAAT_NeurIPS directory. 
 * Modify the dataset field and other relevant parameters in configs/config_v10.yaml to specify which LRA task and experimental setup you wish to run. 

```bash
├── configs/
│   └── config_v10.yaml       # Main configuration file for experiments
├── datasets/                 # (This directory will be created by get_lra_data.sh)
├── __init__.py               # Python package marker
├── dataloader.py             # Data loading and preprocessing
├── get_lra_data.sh           # Script to download LRA datasets
├── lra_config.py             # Configurations/tokenizers for LRA datasets
├── lra_datasets.py           # Dataset classes for LRA benchmarks
├── lra_train.py              # (Potentially LRA specific training logic)
├── model.py                  # Defines the RMAAT neural network architecture
├── req_env_py_310.yml        # Conda environment specification
├── run_train.py              # Main script to launch training
├── run_train.txt             # Example command to run training (may need path adjustment for config)
├── test.ipynb                # Jupyter notebook for testing/prototyping
├── train.py                  # Core training and evaluation loops
├── utils.py                  # Utility functions
└── README.md                 # This file
```
(Note: Adjust paths in commands if your top-level directory is named differently after extraction.)
