import tensorflow
import numpy as np
from tensorflow.keras.layers import *
import math

class DataGeneratorCMNIST(tensorflow.keras.utils.Sequence):
    def __init__(self, in_data, y, batch_size=64):
        self.batch_size = batch_size
        self.in_data = in_data
        self.gt = y
        self.indices = np.arange(np.shape(in_data)[0])

    def __len__(self):
        return math.ceil(np.shape(self.in_data)[0] / self.batch_size)

    def __getitem__(self, idx):
        imgs = []
        lbls = []
        inds = self.indices[idx * self.batch_size:(idx + 1) * self.batch_size]
        for i in range(len(inds)):
            img = self.in_data[inds[i]]
            lbl = self.gt[inds[i]]
            img = img.astype(np.float32)
            img /= 127.5
            img -= 1.
            imgs.append(img)
            lbls.append(lbl)
        return np.array(imgs), np.array(lbls)

    def on_epoch_end(self):
        np.random.shuffle(self.indices)


class TestCallbackMNIST(tensorflow.keras.callbacks.Callback):
    def on_epoch_end(self, epoch, logs=None):
        loss1,  acc1 = \
            self.model.evaluate_generator(test_generator_rb, steps=np.shape(x_test_rgb_rb)[0]//batch_size, verbose=0)
        loss2,   acc2 = \
            self.model.evaluate_generator(test_generator_r, steps=np.shape(x_test_rgb_rb)[0]//batch_size, verbose=0)
        loss3,   acc3 = \
            self.model.evaluate_generator(test_generator_b, steps=np.shape(x_test_rgb_rb)[0]//batch_size, verbose=0)
        loss4,  acc4 = \
            self.model.evaluate_generator(test_generator_none, steps=np.shape(x_test_rgb_rb)[0]//batch_size, verbose=0)
        print('\ntest_rb: {}, test_r: {}, test_b: {}, test_none: {} \n'.format(acc1, acc2, acc3, acc4))



