# AICAU

Repository for "When three experiments are better than two: 
Avoiding intractable correlated aleatoric uncertainty
by leveraging a novel bias–variance tradeoff"

# Installation

Make a new virtual environment

```bash
conda create -n aiau_venv python=3.11
```

activate the environment

```bash
conda activate aiau_venv
```

install basic requirements inside of the activated environment

```bash
conda install scikit-learn pandas matplotlib seaborn tqdm
```

install PyTorch according to hardware:

- For NVIDIA GPU
    ```bash
    pip3 install torch torchvision torchaudio --index-url https://download.pytorch.org/whl/cu118
    ```
- CPU
    ```bash
    pip3 install torch torchvision torchaudio
    ```

From the project directory, install the aiau package

```bash
pip install -e .
```

# Experiment CLI

For convenience, experiments can be run individually using `run_single.py` and `run_batch.py`, you can read the file to see the full list of arguments and possible arguments. An example is presented below.

```bash
python run_single.py \
    --estimation_approach cheat \
    --oracle_type  2 \
    --oracle_noise_level 0.5 \
    --dataset SyntheticFreqPower4_4 \
    --init random \
    --strategy emse
```

# Rerunning paper experiments

For convenience we have included bash scripts to rerun the experiments presented in the paper. These are:

```bash
bash single_setting_experiments.sh
```

```bash
bash batch_setting_experiments.sh
```

These will store the results in `notebooks/results/` which can then be used to create visualisations.