# Contains functions to find the initial labelled indices

import numpy as np

def lower_left_corner_indices_2d(X, num_samples, lower_bound=0, upper_bound=np.pi):
    """
    Find the indices in 2D space of X that are in the lower left corner of the space.

    Args:
        X (np.ndarray): The 2D space.
        num_samples (int): The number of samples to select
        lower_bound (float): The lower bound of the space.
        upper_bound (float): The upper bound of the space.
    
    Returns:
        list: The indices in the lower left corner of the space.
    """
    indices = []
    for i in range(X.shape[0]):
        if X[i, 0] >= lower_bound and X[i, 1] <= upper_bound and X[i, 0] <= upper_bound:
            indices.append(i)
    
    return np.random.choice(indices, num_samples, replace=False)

def random_indices(X, num_samples):
    """
    Find the indices in 2D space of X that are randomly selected.

    Args:
        X (np.ndarray): The 2D space.
        num_samples (int): The number of samples to select
    
    Returns:
        list: The indices randomly selected from the space.
    """
    indices = np.arange(X.shape[0])
    return np.random.choice(indices, num_samples, replace=False)

