# Abstract base class for active learning strategies

from abc import ABC, abstractmethod
from typing import Union
import numpy as np

class AbstractStrategy(ABC):
    """
    Abstract base class for active learning strategies

    Attributes:
        None

    Methods:
        __init__(self): Initializes an AbstractStrategy instance.
        select_next_indices(self, data_manager, model): Selects the next indices to label.
    """

    def __init__(self) -> None:
        super(AbstractStrategy, self).__init__()

    @abstractmethod
    def select_next_indices(self, data_manager, model) -> Union[list[int], np.ndarray]:
        """
        Selects the next indices to label.

        Args:
            data_manager (DataManager): Reference to the data_manager which will load the observation if necessary.
            model (Model): Reference to the model which will be used to predict the target values.

        Returns:
            list: The indices of the observations to label.
        """
        pass