# Random not related note: output = np.maximum(0, self.previous_model_emse - self.previous_model_variance) - np.maximum(0, estimated_mse - ensemble_variance) # This performs abnormally well
import numpy as np

from aiau.strategy.abstract_strategy import AbstractStrategy
from aiau.oracles.oracle import Oracle
from aiau.strategy.bias_estimation import estimate_bias_squared
from aiau.strategy.selection_utils import select_indices_robust

class DiffMaxTermSelectionStrategy(AbstractStrategy):
    """
    Implementation of the DiffMaxTermSelection strategy for active learning.
    
    """

    def __init__(self, estimation_approach: str, oracle_type: str, oracle: Oracle) -> None:
        super(DiffMaxTermSelectionStrategy, self).__init__()
        self.previous_bias_squared = None
        self.previous_model_variance = None
        self.name = "DiffMaxTermSelection"
        self.estimation_approach = estimation_approach
        self.oracle_type = oracle_type
        self.oracle = oracle

    def select_next_indices(self, data_manager, model, num_suggestions, requery=True, batch_strategy="top-k"):
        """
        Selects the next indices to label.

        Args:
            data_manager (DataManager): Reference to the data_manager which will load the observation if necessary.
            model (Model): Reference to the model which will be used to predict the target values.
            num_suggestions (int): The number of indices to suggest for querying.
            requery (bool): Whether to allow requerying of the same observation.

        Returns:
            list: The indices of the observations to label.
        """
        # Predict the target values for all the observations
        ensemble_predictions = model.predict(data_manager.full_X)
        ensemble_variance = np.var(ensemble_predictions, axis=0)
        estimated_bias_squared = estimate_bias_squared(data_manager, model, self.estimation_approach, self.oracle_type, self.oracle)

        if self.previous_bias_squared is None and self.previous_model_variance is None:
            self.previous_bias_squared = np.zeros_like(estimated_bias_squared)
            self.previous_model_variance = np.zeros_like(ensemble_variance)
            kappa_bias = np.abs(self.previous_bias_squared - estimated_bias_squared)
            kappa_variance = np.abs(self.previous_model_variance - ensemble_variance)
            output = np.maximum(kappa_bias, kappa_variance)
        else:
            kappa_bias = self.previous_bias_squared - estimated_bias_squared
            kappa_variance = self.previous_model_variance - ensemble_variance
            output = np.maximum(kappa_bias, kappa_variance)

        # Update the previous bias squared and model variance with the current ones for the next iteration
        self.previous_bias_squared = estimated_bias_squared
        self.previous_model_variance = ensemble_variance
        
        return select_indices_robust(data_manager, output, num_suggestions, requery, batch_strategy)