import numpy as np
from numpy import linalg as LA

def max_entry_basis(vec):
    v = np.abs(vec)
    max_index = np.argmax(v)
    x = np.zeros_like(v)
    x[max_index] = 1
    return x, max_index


def eigen_decomposition_batching(matrix, num_suggestions, requery, data_manager):
    """Decomposes input cobias/comse using eigen decomposition to select indices for batching queries
    """
    eigenvals, eigenvecs = LA.eig(matrix)
    indices = []
    suggestion_counter = 0
    ii = 0
    while suggestion_counter < num_suggestions:
        e_, k_ = max_entry_basis( eigenvecs[:,ii] )
        index = k_
        if requery:
            indices.append(index)
            suggestion_counter += 1
        else:
            if index not in data_manager.labelled_indices:
                indices.append(index)
                suggestion_counter += 1
        ii += 1 # move to the next eigenvector

    return indices