#!/bin/bash

echo "Running batch setting experiments..."

# Define variables
DATASETS=("SyntheticRegular" "SyntheticFreqPower_4_4")
INIT_TYPES=("random")
STRATEGIES=("pemse_pemse_diff" "random" "emse" "least_confidence" "bald")
ESTIMATION_APPROACHES=("cheat" "direct")
ORACLE_TYPES=(1 2 3)
ORACLE_NOISE_LEVEL=(0.5 1.0)
BATCH_STRATEGY=("top-k")

for batch_strategy in "${BATCH_STRATEGY[@]}"; do
    for init_type in "${INIT_TYPES[@]}"; do
        for strategy in "${STRATEGIES[@]}"; do
            for estimation_approach in "${ESTIMATION_APPROACHES[@]}"; do
                for oracle_type in "${ORACLE_TYPES[@]}"; do
                    for oracle_noise_level in "${ORACLE_NOISE_LEVEL[@]}"; do
                        for dataset in "${DATASETS[@]}"; do
                            python run_batch.py \
                                --estimation_approach $estimation_approach \
                                --oracle_type $oracle_type \
                                --oracle_noise_level $oracle_noise_level \
                                --dataset $dataset \
                                --init $init_type \
                                --strategy $strategy \
                                --batch_strategy $batch_strategy \
                                --output_dir "notebooks/monday"
                        done
                    done
                done
            done
        done
    done
done


# Define variables
DATASETS=("SyntheticRegular" "SyntheticFreqPower_4_4")
INIT_TYPES=("random")
STRATEGIES=("pemse_pemse_diff" "emse")
ESTIMATION_APPROACHES=("cheat" "direct")
ORACLE_TYPES=(1 2 3)
ORACLE_NOISE_LEVEL=(0.5 1.0)
BATCH_STRATEGY=("eigen-decomposition")

for batch_strategy in "${BATCH_STRATEGY[@]}"; do
    for init_type in "${INIT_TYPES[@]}"; do
        for strategy in "${STRATEGIES[@]}"; do
            for estimation_approach in "${ESTIMATION_APPROACHES[@]}"; do
                for oracle_type in "${ORACLE_TYPES[@]}"; do
                    for oracle_noise_level in "${ORACLE_NOISE_LEVEL[@]}"; do
                        for dataset in "${DATASETS[@]}"; do
                            python run_batch.py \
                                --estimation_approach $estimation_approach \
                                --oracle_type $oracle_type \
                                --oracle_noise_level $oracle_noise_level \
                                --dataset $dataset \
                                --init $init_type \
                                --strategy $strategy \
                                --batch_strategy $batch_strategy \
                                --output_dir "notebooks/monday"
                        done
                    done
                done
            done
        done
    done
done