#!/bin/bash

# Add your commands below

echo "Running single setting experiments..."
# Example command
# ./run_experiment.sh --setting single

# Add more commands as needed
# python run_single.py \
#     --estimation_approach cheat \
#     --oracle_type  1 \
#     --oracle_noise_level 0.5 \
#     --dataset SyntheticRegular \
#     --init corner \
#     --strategy random 

# Define variables
DATASETS=("SyntheticRegular" "SyntheticFreqPower_4_4")
INIT_TYPES=("random")
STRATEGIES=("random" "least_confidence" "emse" "bias_reduction" "max_term_selection" "diff_least_confidence" "diff_emse" "diff_bias_reduction" "diff_max_term_selection" "bald")
ESTIMATION_APPROACHES=("cheat")
ORACLE_TYPES=(1 2 3)
ORACLE_NOISE_LEVEL=(0.5 1.0)

for dataset in "${DATASETS[@]}"; do
    for init_type in "${INIT_TYPES[@]}"; do
        for strategy in "${STRATEGIES[@]}"; do
            for estimation_approach in "${ESTIMATION_APPROACHES[@]}"; do
                for oracle_type in "${ORACLE_TYPES[@]}"; do
                    for oracle_noise_level in "${ORACLE_NOISE_LEVEL[@]}"; do
                        python run_single.py \
                            --estimation_approach $estimation_approach \
                            --oracle_type $oracle_type \
                            --oracle_noise_level $oracle_noise_level \
                            --dataset $dataset \
                            --init $init_type \
                            --strategy $strategy \
                            --output_dir "notebooks/new_results"
                    done
                done
            done
        done
    done
done

